﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_Out.h>
#include <nn/sf/sf_NativeHandleFwd.h>
#include <nn/grc/grc_CommonTypes.h>
#include <nn/capsrv/capsrv_ApplicationData.h>

namespace nn{ namespace grcsrv{

    class MovieMakerClient
    {
    public:
        explicit MovieMakerClient(nn::applet::AppletResourceUserId aruid, ncm::ApplicationId applicationId) NN_NOEXCEPT;
        ~MovieMakerClient() NN_NOEXCEPT;

        bool IsAlive() const NN_NOEXCEPT;
        void Invalidate() NN_NOEXCEPT;
    private:
        void CloseAllOffscreenLayerImpl() NN_NOEXCEPT;

    public:
        nn::Result OpenOffscreenLayer(std::int32_t* pOutProducerHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result CloseOffscreenLayer(std::uint64_t layerHandle) NN_NOEXCEPT;

        nn::Result StartOffscreenRecording(std::uint64_t layerHandle, const nn::grc::OffscreenRecordingParameter& param) NN_NOEXCEPT;
        nn::Result AbortOffscreenRecording(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result RequestOffscreenRecordingFinishReady(std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result CompleteOffscreenRecordingFinish(std::uint64_t layerHandle, const capsrv::ApplicationData& applicationData, const sf::InBuffer& thumbnailImage) NN_NOEXCEPT;

        nn::Result GetOffscreenLayerError(std::uint64_t layerHandle) NN_NOEXCEPT;

        nn::Result EncodeOffscreenLayerAudioSample(nn::sf::Out<std::uint64_t> outEncodedSize, std::uint64_t layerHandle, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;

        nn::Result GetOffscreenLayerRecordingFinishReadyEvent(nn::sf::Out<nn::sf::NativeHandle>& outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;
        nn::Result GetOffscreenLayerAudioEncodeReadyEvent(nn::sf::Out<nn::sf::NativeHandle>& outHandle, std::uint64_t layerHandle) NN_NOEXCEPT;

        void TransactParcel(std::int32_t handle, std::uint32_t code, const nn::sf::InBuffer& requestBuffer, const nn::sf::OutBuffer& replyBuffer, std::uint32_t flags) NN_NOEXCEPT;
        void AdjustRefcount(std::int32_t handle, std::int32_t diff, std::int32_t isStrong) NN_NOEXCEPT;
        void GetNativeHandle(std::int32_t handle, std::uint32_t code, nn::sf::Out<nn::sf::NativeHandle> result) NN_NOEXCEPT;

    private:
        bool m_IsAlive;
        nn::applet::AppletResourceUserId m_Aruid;
        nn::ncm::ApplicationId m_ApplicationId;
        int m_LayerDestroyingCallbackSlot;

        // (layerHandle, binderHandle)
        nn::util::optional<std::pair<uint64_t, int32_t>> m_BoundLayerHandle;

        nn::util::optional<uint64_t> m_RecordingLayerHandle;
    };

}}
