﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/grcsrv/grcsrv_GrcServices.sfdl.h>

#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/sf/sf_NativeHandle.h>
#include "grcsrv_SubTaskThread.h"

#include <nn/grcsrv/grcsrv_MovieFileReader.h>
#include <nn/grcsrv/grcsrv_MovieFileWriter.h>
#include "grcsrv_TransferMemoryHolder.h"

namespace nn { namespace fs {
struct FileHandle;
}}

namespace nn { namespace grcsrv {

class MovieFileReader;
class MovieFileWriter;

class GameMovieTrimmerImpl
    : private detail::SubTaskThread
{
private:

    MovieFileReader* m_pMovieFileReader;
    MovieFileWriter* m_pMovieFileWriter;

    bool m_Initialized = false;
    void FinalizeImpl() NN_NOEXCEPT;

    detail::TransferMemoryHolder m_MemoryHolder;

    // resource
    void* m_TrimBuffer;
    size_t m_TrimBufferSize;
    void* m_MetaBuffer;
    size_t m_MetaBufferSize;
    void* m_ImageBuffer;
    size_t m_ImageBufferSize;

    // in
    capsrv::AlbumFileId m_InFileId;
    int m_BeginIndex;
    int m_EndIndex;

    // out
    Result m_Result;
    capsrv::AlbumFileId m_OutFileId;

    Result DoTaskImpl() NN_NOEXCEPT;

    virtual void DoTask() NN_NOEXCEPT NN_OVERRIDE;
    virtual void DoCancel() NN_NOEXCEPT NN_OVERRIDE;

public:

    NN_IMPLICIT GameMovieTrimmerImpl(MovieFileReader* pMovieFileReader, MovieFileWriter* pMovieFileWriter) NN_NOEXCEPT;
    Result Initialize(sf::NativeHandle&& workMemoryHandle, uint64_t workMemorySize, int trimThreadPriority, const char* trimThreadName) NN_NOEXCEPT;
    ~GameMovieTrimmerImpl() NN_NOEXCEPT;

    Result GetNotTrimmingEvent(sf::Out<sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
    Result BeginTrim(const capsrv::AlbumFileId& id, int beginIndex, int endIndex) NN_NOEXCEPT;
    Result BeginTrim(const GameMovieId& id, int beginIndex, int endIndex) NN_NOEXCEPT;
    Result EndTrim(sf::Out<GameMovieId> pOut) NN_NOEXCEPT;
    Result SetThumbnailRgba(const sf::InBuffer& imageData, int width, int height) NN_NOEXCEPT;

    using SubTaskThread::IsRunning;

};

}}
