﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/util/gfx_ObjectDebugLabel.h>

namespace nn {
namespace gfx {
namespace util {

#if NN_GFX_IS_TARGET_VK

typedef ApiVariationVk1 Target;

template<>
void SetMemoryPoolDebugLabel(TMemoryPool< Target >* pMemoryPool, const char* label) NN_NOEXCEPT
{
    NN_UNUSED( pMemoryPool );
    NN_UNUSED( label );
}

template<>
void SetBufferDebugLabel(TBuffer< Target >* pBuffer, const char* label) NN_NOEXCEPT
{
    NN_UNUSED( pBuffer );
    NN_UNUSED( label );
}

template<>
void SetTextureDebugLabel(TTexture< Target >* pTexture, const char* label) NN_NOEXCEPT
{
    NN_UNUSED( pTexture );
    NN_UNUSED( label );
}

template<>
void SetSamplerDebugLabel(TSampler< Target >* pSampler, const char* label) NN_NOEXCEPT
{
    NN_UNUSED( pSampler );
    NN_UNUSED( label );
}

#endif //NN_GFX_IS_TARGET_VK

} // namespace util
} // namespace gfx
} // namespace nn
