﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/util/gfx_ObjectDebugLabel.h>
#include <nvn/nvn.h>
#include <nvn/nvn_FuncPtrInline.h>

namespace nn {
namespace gfx {
namespace util {

#if NN_GFX_IS_TARGET_NVN

typedef ApiVariationNvn8 Target;

template<>
void SetMemoryPoolDebugLabel(TMemoryPool< Target >* pMemoryPool, const char* label) NN_NOEXCEPT
{
    nvnMemoryPoolSetDebugLabel(pMemoryPool->ToData()->pNvnMemoryPool, label);
}

template<>
void SetBufferDebugLabel(TBuffer< Target >* pBuffer, const char* label) NN_NOEXCEPT
{
    nvnBufferSetDebugLabel(pBuffer->ToData()->pNvnBuffer, label);
}

template<>
void SetTextureDebugLabel(TTexture< Target >* pTexture, const char* label) NN_NOEXCEPT
{
    nvnTextureSetDebugLabel(pTexture->ToData()->pNvnTexture, label);
}

template<>
void SetSamplerDebugLabel(TSampler< Target >* pSampler, const char* label) NN_NOEXCEPT
{
    nvnSamplerSetDebugLabel(pSampler->ToData()->pNvnSampler, label);
}

#endif // NN_GFX_IS_TARGET_NVN

} // namespace util
} // namespace gfx
} // namespace nn
