﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfx/gfx_ResTexture.h>

namespace nn {
namespace gfx {

size_t ResTextureFile::GetMaxFileAlignment() NN_NOEXCEPT
{
    return 128 * 1024;
}

bool ResTextureFile::IsValid( const void* ptr ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( ptr );

    const nn::util::BinaryFileHeader* pFileHeader =
        static_cast< const nn::util::BinaryFileHeader* >( ptr );

    return pFileHeader->IsValid( Signature, MajorVersion, MinorVersion, MicroVersion );
}

ResTextureFile* ResTextureFile::ResCast( void* ptr ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( ptr );

    ResTextureFile::value_type* pData = static_cast< ResTextureFile::value_type* >( ptr );
    ResTextureFile* pRet = ToAccessor( pData );

    NN_SDK_ASSERT( pRet->fileHeader.IsValid( Signature, MajorVersion, MinorVersion, MicroVersion ) );

    // TODO: エンディアン

    if( !pRet->fileHeader.IsRelocated() )
    {
        pRet->fileHeader.GetRelocationTable()->Relocate();
    }

    return pRet;
}

NN_STATIC_ASSERT( sizeof( ResTextureData ) == 160 );
NN_STATIC_ASSERT( sizeof( ResTextureContainerData ) == 56 );
NN_STATIC_ASSERT( sizeof( ResTextureFileData ) == 88 );

}
}
