﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfx/gfx_Interop-api.gx.2.h>

#include <nn/gfx/gfx_Buffer.h>
#include <nn/gfx/gfx_Sampler.h>
#include <nn/gfx/gfx_Texture.h>

#include <nn/gfx/detail/gfx_Buffer-api.gx.2.h>
#include <nn/gfx/detail/gfx_Sampler-api.gx.2.h>
#include <nn/gfx/detail/gfx_Shader-api.gx.2.h>
#include <nn/gfx/detail/gfx_Texture-api.gx.2.h>

#include "detail/gfx_GxHelper.h"

namespace nn {
namespace gfx {

typedef ApiVariationGx2 Target;

void TInteroperation< Target >::ConvertToGfxBuffer( TBuffer< Target >* pOutGfxBuffer,
    void* pGx2Buffer, size_t size ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutGfxBuffer );
    NN_SDK_REQUIRES( !IsInitialized( *pOutGfxBuffer ) );

    TBuffer< Target >::DataType& obj = pOutGfxBuffer->ToData();
    obj.state = TBuffer< Target >::DataType::State_Initialized;
    obj.flags.SetBit( TBuffer< Target >::DataType::Flag_Shared, true );
    obj.pBuffer = pGx2Buffer;
    obj.size = static_cast< uint32_t >( size );
}

void TInteroperation< Target >::ConvertToGfxSampler( TSampler< Target >* pOutGfxSampler,
    GX2Sampler* pGx2Sampler ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutGfxSampler );
    NN_SDK_REQUIRES( !IsInitialized( *pOutGfxSampler ) );

    TSampler< Target >::DataType& obj = pOutGfxSampler->ToData();
    obj.state = TSampler< Target >::DataType::State_Initialized;
    obj.flags.SetBit( TSampler< Target >::DataType::Flag_Shared, true );
    obj.pGx2Sampler = pGx2Sampler;
}

void TInteroperation< Target >::ConvertToGfxTexture( TTexture< Target >* pOutGfxTexture,
    GX2Surface* pGx2Surface ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutGfxTexture );
    NN_SDK_REQUIRES( !IsInitialized( *pOutGfxTexture ) );

    TTexture< Target >::DataType& obj = pOutGfxTexture->ToData();
    obj.state =TTexture< Target >::DataType::State_Initialized;
    obj.flags.SetBit( TTexture< Target >::DataType::Flag_Shared, true );
    obj.pGx2Surface = pGx2Surface;
}

void TInteroperation< Target >::ConvertToGfxTextureView(
    TTextureView< Target >* pOutGfxTextureView, GX2Texture* pGx2Texture ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutGfxTextureView );
    NN_SDK_REQUIRES( !IsInitialized( *pOutGfxTextureView ) );

    TTextureView< Target >::DataType& obj = pOutGfxTextureView->ToData();
    obj.state = TTextureView< Target >::DataType::State_Initialized;
    obj.flags.SetBit( TTextureView< Target >::DataType::Flag_Shared, true );
    obj.pGx2Texture = pGx2Texture;
}

void TInteroperation< Target >::ConvertToGfxColorTargetView(
    TColorTargetView< Target >* pOutGfxColorTargetView, GX2ColorBuffer* pGx2ColorBuffer ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutGfxColorTargetView );
    NN_SDK_REQUIRES( !IsInitialized( *pOutGfxColorTargetView ) );

    TColorTargetView< Target >::DataType& obj = pOutGfxColorTargetView->ToData();
    obj.state = TColorTargetView< Target >::DataType::State_Initialized;
    obj.flags.SetBit( TColorTargetView< Target >::DataType::Flag_Shared, true );
    obj.pGx2ColorBuffer = pGx2ColorBuffer;
}

void TInteroperation< Target >::ConvertToGfxDepthStencilView(
    TDepthStencilView< Target >* pOutGfxDepthStencilView, GX2DepthBuffer* pGx2DepthBuffer ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutGfxDepthStencilView );
    NN_SDK_REQUIRES( !IsInitialized( *pOutGfxDepthStencilView ) );

    TDepthStencilView< Target >::DataType& obj = pOutGfxDepthStencilView->ToData();
    obj.state = TDepthStencilView< Target >::DataType::State_Initialized;
    obj.flags.SetBit( TDepthStencilView< Target >::DataType::Flag_Shared, true );
    obj.pGx2DepthBuffer = pGx2DepthBuffer;
}

}
}
