﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>

#include <nn/nn_Macro.h>
#include <nn/nn_Windows.h>

#if !defined( NN_BUILD_CONFIG_OS_WIN32 )
    #error
#endif

#include <nn/vi/vi_Layer.h>

#include <nn/gfx/gfx_SwapChainInfo.h>
#include <nn/gfx/gfx_DataAccessorConverter.h>
#include <nn/gfx/gfx_Texture.h>

#include <nn/gfx/detail/gfx_SwapChain-api.gl.4-os.win32.h>
#include <nn/gfx/detail/gfx_Device-api.gl.4-os.win32.h>
#include <nn/gfx/detail/gfx_Texture-api.gl.4.h>
#include <nn/gfx/detail/gfx_MemoryPool-api.gl.4.h>
#include <nn/gfx/detail/gfx_Sync-api.gl.4.h>

#include "gfx_CommonHelper.h"
#include "gfx_GlHelper.h"
#include "gfx_WglHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationGl4 Target;

void InitializeSwapChainCommonImpl( SwapChainImpl< Target >* pThis, DeviceImpl< Target >* pDevice,
    const SwapChainInfo& info, MemoryPoolImpl< Target >* pMemoryPool,
    ptrdiff_t memoryPoolOffset, size_t memoryPoolSize ) NN_NOEXCEPT;
void FinalizeSwapChainCommonImpl( SwapChainImpl< Target >* pThis,
    DeviceImpl< Target >* pDevice ) NN_NOEXCEPT;

void SwapChainImpl< Target >::Initialize( DeviceImpl< Target >* pDevice, const InfoType& info,
    MemoryPoolImpl< Target >* pMemoryPool, ptrdiff_t memoryPoolOffset, size_t memoryPoolSize ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pDevice );
    NN_SDK_REQUIRES( this->state == State_NotInitialized );
    NN_SDK_ASSERT( this->pGfxDevice == NULL );
    NN_SDK_REQUIRES( !pMemoryPool || IsInitialized( *pMemoryPool ) );
    NN_SDK_ASSERT( !pMemoryPool || pMemoryPool->ToData()->pMemory );
    NN_SDK_REQUIRES( !pMemoryPool || memoryPoolSize >= CalculateScanBufferSize( pDevice, info ) );
    NN_SDK_ASSERT( !pMemoryPool || pMemoryPool->ToData()->memorySize >= memoryPoolOffset + memoryPoolSize );

    this->pGfxDevice = pDevice;

    nn::vi::NativeWindowHandle hNativeWindow = NULL;
    nn::Result viResult;
    NN_GFX_CALL_NNVI_FUNCTION(
        viResult = nn::vi::GetNativeWindow( &hNativeWindow, info.GetLayer() ) );
    NN_SDK_ASSERT( viResult.IsSuccess() );
    NN_UNUSED( viResult );

    this->hWnd = hNativeWindow;
    this->hDc = ::GetDC( static_cast< HWND >( this->hWnd ) );
    NN_SDK_ASSERT_NOT_NULL( this->hDc );

    Wgl::SetPixelFormat( static_cast< HDC >( this->hDc ) );

    InitializeSwapChainCommonImpl( this, pDevice, info, pMemoryPool, memoryPoolOffset, memoryPoolSize );

    this->state = State_Initialized;
}

void SwapChainImpl< Target >::Finalize( DeviceImpl< Target >* pDevice ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pDevice );
    NN_SDK_REQUIRES( this->state == State_Initialized );
    NN_UNUSED( pDevice );

    FinalizeSwapChainCommonImpl( this, pDevice );

    if( this->hDc )
    {
        ::ReleaseDC( static_cast< HWND >( this->hWnd ), static_cast< HDC >( this->hDc ) );
        this->hDc = NULL;
    }

    this->pGfxDevice = NULL;

    this->state = State_NotInitialized;
}

}
}
}
