﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nvn/nvn.h>
#include <nvn/nvn_FuncPtrInline.h>

#include <nvnTool/nvnTool_GlslcInterface.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>

#include <nn/util/util_BitPack.h>

#include <nn/gfx/gfx_Enum.h>
#include <nn/gfx/gfx_SwapChainInfo.h>
#include <nn/gfx/gfx_TextureInfo.h>
#include <nn/gfx/gfx_GpuAddress.h>

#include <nn/gfx/detail/gfx_Common-api.nvn.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

#define NN_GFX_CALL_NVN_FUNCTION(func) (func)

namespace nn {
namespace gfx {
namespace detail {

enum NvnDeviceFeature
{
    NvnDeviceFeature_SupportMinMaxFiltering,
    NvnDeviceFeature_SupportStencil8Format,
    NvnDeviceFeature_SupportAstcFormat,
    NvnDeviceFeature_SupportConservativeRaster,
    NvnDeviceFeature_SupportZeroFromUnmappedVirtualPoolPage,
    NvnDeviceFeature_SupportPassthroughGeometryShader,
    NvnDeviceFeature_SupportViewportSwizzle,
    NvnDeviceFeature_SupportSparseTiledPackagedTexture,
    NvnDeviceFeature_AdvancedBlendModes,
    NvnDeviceFeature_DrawTexture,
    NvnDeviceFeature_TargetIndependentRasterization,
    NvnDeviceFeature_FragmentCoverageToColor,
    NvnDeviceFeature_PostDepthCoverage,
    NvnDeviceFeature_ImagesUsingTextureHandles,
    NvnDeviceFeature_SampleLocations,
    NvnDeviceFeature_SupportFragmentShaderInterlock,
    NvnDeviceFeature_SupportsDebugLayer
};

class Nvn
{
public:
    static int GetCpuMapAccess( int access ) NN_NOEXCEPT;
    static NVNformat GetImageFormat( ImageFormat format ) NN_NOEXCEPT;
    static NVNformat GetAttributeFormat( AttributeFormat format ) NN_NOEXCEPT;
    static NVNtextureTarget GetImageTarget( ImageDimension dimension ) NN_NOEXCEPT;
    static NVNdepthFunc GetDepthFunction( ComparisonFunction compare ) NN_NOEXCEPT;
    static NVNstencilOp GetStencilOperation( StencilOperation operation ) NN_NOEXCEPT;
    static NVNstencilFunc GetStencilFunction( ComparisonFunction compare ) NN_NOEXCEPT;
    static NVNblendEquation GetBlendEquation( BlendFunction function ) NN_NOEXCEPT;
    static NVNblendFunc GetBlendFunction( BlendFactor factor ) NN_NOEXCEPT;
    static NVNlogicOp GetLogicOperation( LogicOperation operation ) NN_NOEXCEPT;
    static NVNfrontFace GetFrontFace( FrontFace face ) NN_NOEXCEPT;
    static NVNpolygonMode GetFillMode( FillMode mode ) NN_NOEXCEPT;
    static NVNdrawPrimitive GetDrawPrimitive( PrimitiveTopology topology ) NN_NOEXCEPT;
    static NVNminFilter GetMinFilter( FilterMode filterMode ) NN_NOEXCEPT;
    static NVNmagFilter GetMagFilter( FilterMode filterMode ) NN_NOEXCEPT;
    static NVNwrapMode GetWrapMode( TextureAddressMode wrapMode ) NN_NOEXCEPT;
    static NVNshaderStage GetShaderStage( ShaderStage stage ) NN_NOEXCEPT;
    static int GetShaderStageBits( int shaderStageBits ) NN_NOEXCEPT;
    static NVNcompareFunc GetRComparisonFunction( ComparisonFunction compare ) NN_NOEXCEPT;
    static NVNindexType GetIndexFormat( IndexFormat indexFormat ) NN_NOEXCEPT;
    static NVNface GetCullMode( CullMode face ) NN_NOEXCEPT;
    static int GetMemoryPoolFlags( int memoryPoolProperty) NN_NOEXCEPT;
    static NVNbufferAddress GetBufferAddress(const GpuAddress gpuAddress) NN_NOEXCEPT;
    static NVNcounterType GetCounterType( QueryTarget target ) NN_NOEXCEPT;

    static nn::util::BitPack32 GetDeviceFeature( const NVNdevice* pDevice ) NN_NOEXCEPT;

    static void SetupScanBufferTextureInfo( TextureInfo* pOutInfo, const SwapChainInfo& info ) NN_NOEXCEPT;

    static nn::TimeSpan ToTimeSpan( int64_t timestamp ) NN_NOEXCEPT;

    static ImageFormat GetGfxImageFormat( NVNformat nvnFormat ) NN_NOEXCEPT;
    static void GetImageFormatProperty( ImageFormatProperty* pOutImageFormatProperty,
        NVNformat nvnFormat ) NN_NOEXCEPT;

    static int GetFirstScanBufferIndex() NN_NOEXCEPT;

    static void SetPackagedTextureDataImpl( NVNtextureBuilder* pTextureBuilder, const TextureInfo& info,
        MemoryPoolImpl< ApiVariationNvn8 >* pMemoryPool, ptrdiff_t memoryPoolOffset, size_t memoryPoolSize ) NN_NOEXCEPT;

    static void SetTextureViewFormat( NVNtextureView* pTextureView, NVNformat value,
        const NVNtexture* pTexture ) NN_NOEXCEPT;

    static void NVNAPIENTRY DebugCallback( NVNdebugCallbackSource source, NVNdebugCallbackType type,
        int id, NVNdebugCallbackSeverity severity, const char* message, void* );
};

template< typename TObject >
inline bool IsInitialized( const TObject& obj ) NN_NOEXCEPT
{
    return obj.ToData()->state == TObject::DataType::State_Initialized;
}

class GlslcDll
{
    NN_DISALLOW_COPY( GlslcDll );

public:
    static GlslcDll& GetInstance() NN_NOEXCEPT;

    GlslcDll() NN_NOEXCEPT;
    ~GlslcDll() NN_NOEXCEPT;

    bool Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    bool IsInitialized() const NN_NOEXCEPT;

    typedef bool( *GlslcCompilePreSpecializedType )( GLSLCcompileObject* compileObject );
    typedef const GLSLCoutput* const* ( *GlslcCompileSpecializedType )(
        GLSLCcompileObject* compileObject, const GLSLCspecializationBatch* specEntries );
    typedef uint8_t( *GlslcInitializeType )( GLSLCcompileObject* compileObject );
    typedef void( *GlslcFinalizeType )( GLSLCcompileObject* compileObject );
    typedef uint8_t( *GlslcCompileType )( GLSLCcompileObject* compileObject );
    typedef GLSLCversion( *GlslcGetVersionType )( );
    typedef void( *GlslcSetAllocatorType )(
        GLSLCallocateFunction, GLSLCfreeFunction, GLSLCreallocateFunction, void* );
    typedef GLSLCoptions( *GlslcGetDefaultOptionsType )( );

    GlslcCompilePreSpecializedType GlslcCompilePreSpecialized;
    GlslcCompileSpecializedType GlslcCompileSpecialized;
    GlslcInitializeType GlslcInitialize;
    GlslcFinalizeType GlslcFinalize;
    GlslcCompileType GlslcCompile;
    GlslcGetVersionType GlslcGetVersion;
    GlslcSetAllocatorType GlslcSetAllocator;
    GlslcGetDefaultOptionsType GlslcGetDefaultOptions;

private:
    void* m_hDll;
};

bool IsThinBinaryAvailable() NN_NOEXCEPT;

}
}
}
