﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>

#include <nn/nn_SdkAssert.h>

#include <nn/os/os_MutexApi.h>

#include <nn/gfx/detail/gfx_Device-api.gl.4-os.horizon.h>
#include <nn/gfx/detail/gfx_SwapChain-api.gl.4-os.horizon.h>
#include <nn/gfx/detail/gfx_Queue-api.gl.4.h>

#include "gfx_CommonHelper.h"
#include "gfx_GlHelper.h"
#include "gfx_EglHelper.h"

namespace nn {
namespace gfx {
namespace detail {

// もし多くなってきたら再検討
typedef void( *GlPolygonModeProcType )( GLenum, GLenum );
typedef void( *GlLogicOpProcType )( GLenum );

void Gl::PolygonMode( GLenum face, GLenum mode ) NN_NOEXCEPT
{
    static GlPolygonModeProcType s_pPolygonMode = NULL;
    if( s_pPolygonMode == NULL )
    {
        NN_GFX_CALL_EGL_FUNCTION( s_pPolygonMode = reinterpret_cast<
            GlPolygonModeProcType>( eglGetProcAddress( "glPolygonMode" ) ) );
        NN_SDK_ASSERT_NOT_NULL( s_pPolygonMode );
    }

    return s_pPolygonMode( face, mode );
}

void Gl::LogicOp( GLenum opcode ) NN_NOEXCEPT
{
    static GlLogicOpProcType s_pLogicOp = NULL;
    if( s_pLogicOp == NULL )
    {
        NN_GFX_CALL_EGL_FUNCTION( s_pLogicOp = reinterpret_cast<
            GlLogicOpProcType >( eglGetProcAddress( "glLogicOp" ) ) );
        NN_SDK_ASSERT_NOT_NULL( s_pLogicOp );
    }

    return s_pLogicOp( opcode );
}

void Gl::GetSurfaceSize( int* pOutWidth, int* pOutHeight,
    SwapChainImpl< ApiVariationGl4 >* pSwapChain ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pOutWidth );
    NN_SDK_ASSERT_NOT_NULL( pOutHeight );
    NN_SDK_ASSERT_NOT_NULL( pSwapChain );

    SwapChainImpl< ApiVariationGl4 >::DataType& swapChain = pSwapChain->ToData();
    NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK_RESULT( eglQuerySurface(
        swapChain.pGfxDevice->ToData()->hDisplay, swapChain.hSurface, EGL_WIDTH, pOutWidth ) );
    NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK_RESULT( eglQuerySurface(
        swapChain.pGfxDevice->ToData()->hDisplay, swapChain.hSurface, EGL_HEIGHT, pOutHeight ) );
}

template<>
void GlDeviceActivator::Activate< ApiVariationGl4 >(
    DeviceImpl< ApiVariationGl4 >* pTarget, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pTarget );

    DeviceImpl< ApiVariationGl4 >::DataType& data = pTarget->ToData();
    Activate( data.hDisplay, data.hSurface, &data.renderingContext, overwrite );
}

template<>
void GlDeviceActivator::Activate< ApiVariationGl4 >(
    QueueImpl< ApiVariationGl4 >* pTarget, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pTarget );

    QueueImpl< ApiVariationGl4 >::DataType& data = pTarget->ToData();
    Activate( data.hDisplay, data.hSurface, &data.renderingContext, overwrite );
}

template<>
void GlDeviceActivator::Activate< ApiVariationGl4 >(
    SwapChainImpl< ApiVariationGl4 >* pSwapChain,
    GlRenderingContext* pRenderingContext, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( pSwapChain );
    NN_SDK_ASSERT_NOT_NULL( pRenderingContext );

    SwapChainImpl< ApiVariationGl4 >::DataType& data = pSwapChain->ToData();
    NN_SDK_ASSERT_NOT_NULL( data.pGfxDevice.ptr );
    Activate( data.pGfxDevice->ToData()->hDisplay, data.hSurface, pRenderingContext, overwrite );
}

void GlDeviceActivator::Activate( void* display, void* surface,
    GlRenderingContext* pRenderingContext, bool overwrite ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( display );
    NN_SDK_ASSERT_NOT_NULL( pRenderingContext );
    NN_SDK_ASSERT_NOT_NULL( surface );
    NN_SDK_ASSERT_NOT_NULL( pRenderingContext->hGlRc.ptr );

    m_pMutex = NULL;
    NN_GFX_CALL_EGL_FUNCTION( m_Egl.hDisplay = eglGetCurrentDisplay() );
    NN_GFX_CALL_EGL_FUNCTION( m_Egl.hDrawSurface = eglGetCurrentSurface( EGL_DRAW ) );
    NN_GFX_CALL_EGL_FUNCTION( m_Egl.hReadSurface = eglGetCurrentSurface( EGL_READ ) );
    NN_GFX_CALL_EGL_FUNCTION( m_Egl.hContext = eglGetCurrentContext() );

    if( m_Egl.hContext == EGL_NO_CONTEXT || m_Egl.hDrawSurface != surface || m_Egl.hDisplay != display ||
        ( overwrite && m_Egl.hContext != pRenderingContext->hGlRc ) )
    {
        m_pMutex = &pRenderingContext->mutex;
        NN_GFX_CALL_NNOS_FUNCTION( nn::os::LockMutex( m_pMutex ) );
        Egl::MakeCurrent( display, surface, surface, pRenderingContext->hGlRc );
        if( m_Egl.hDisplay == NULL )
        {
            m_Egl.hDisplay = display;
        }
    }
}

GlDeviceActivator::~GlDeviceActivator() NN_NOEXCEPT
{
    if( m_pMutex )
    {
        Egl::MakeCurrent( m_Egl.hDisplay, m_Egl.hDrawSurface, m_Egl.hReadSurface, m_Egl.hContext );
        NN_GFX_CALL_NNOS_FUNCTION( nn::os::UnlockMutex( m_pMutex ) );
        m_pMutex = NULL;
        m_Egl.hDisplay = NULL;
        m_Egl.hDrawSurface = NULL;
        m_Egl.hReadSurface = NULL;
        m_Egl.hContext = NULL;
    }
}

}
}
}
