﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>

#include <nn/os/os_Mutex.h>

#include "gfx_EglHelper.h"

namespace nn {
namespace gfx {
namespace detail {

#define NN_GFX_CASE_STRING( value ) case value: return #value

const char* Egl::ErrorToString( EGLint error ) NN_NOEXCEPT
{
    switch( error )
    {
        NN_GFX_CASE_STRING( EGL_SUCCESS );
        NN_GFX_CASE_STRING( EGL_NOT_INITIALIZED );
        NN_GFX_CASE_STRING( EGL_BAD_ACCESS );
        NN_GFX_CASE_STRING( EGL_BAD_ALLOC );
        NN_GFX_CASE_STRING( EGL_BAD_ATTRIBUTE );
        NN_GFX_CASE_STRING( EGL_BAD_CONTEXT );
        NN_GFX_CASE_STRING( EGL_BAD_CONFIG );
        NN_GFX_CASE_STRING( EGL_BAD_CURRENT_SURFACE );
        NN_GFX_CASE_STRING( EGL_BAD_DISPLAY );
        NN_GFX_CASE_STRING( EGL_BAD_SURFACE );
        NN_GFX_CASE_STRING( EGL_BAD_MATCH );
        NN_GFX_CASE_STRING( EGL_BAD_PARAMETER );
        NN_GFX_CASE_STRING( EGL_BAD_NATIVE_PIXMAP );
        NN_GFX_CASE_STRING( EGL_BAD_NATIVE_WINDOW );
        NN_GFX_CASE_STRING( EGL_CONTEXT_LOST );
    default:
        return "Unknown Error";
    }
}

void Egl::MakeCurrent( EGLDisplay dpy,
    EGLSurface draw, EGLSurface read, EGLContext ctx ) NN_NOEXCEPT
{
    NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK_RESULT( eglMakeCurrent( dpy, draw, read, ctx ) );
}

EGLConfig Egl::GetConfig( EGLDisplay dpy, EGLContext ctx ) NN_NOEXCEPT
{
    EGLint configId = EGLint();
    NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK_RESULT(
        eglQueryContext( dpy, ctx, EGL_CONFIG_ID, &configId ) );
    return reinterpret_cast<EGLConfig>( configId );
}

EGLConfig Egl::GetConfig( EGLDisplay dpy ) NN_NOEXCEPT
{
    const EGLint configAttribs[] =
    {
        EGL_RENDERABLE_TYPE, EGL_OPENGL_BIT,
        EGL_SURFACE_TYPE, EGL_WINDOW_BIT,
        EGL_RED_SIZE, 8,
        EGL_GREEN_SIZE, 8,
        EGL_BLUE_SIZE, 8,
        EGL_ALPHA_SIZE, 8,
        EGL_NONE
    };

    EGLint configCount = EGLint();
    NN_UNUSED( configCount );
    EGLConfig hConfig = EGLConfig();
    NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK_RESULT( eglChooseConfig(
        dpy, configAttribs, &hConfig, 1, &configCount ) );
    NN_SDK_ASSERT_EQUAL( configCount, 1 );

    return hConfig;
}

EGLContext Egl::CreateGlRc( EGLDisplay dpy, EGLConfig config,
    EGLContext sharedRc, int majorVersion, int minorVersion ) NN_NOEXCEPT
{
    const EGLint contextAttribs[] =
    {
        EGL_CONTEXT_MAJOR_VERSION, majorVersion,
        EGL_CONTEXT_MINOR_VERSION, minorVersion,
        EGL_NONE
    };
    EGLContext ret = EGL_NO_CONTEXT;
    NN_GFX_CALL_EGL_FUNCTION_WITH_CHECK( ret =
        eglCreateContext( dpy, config, sharedRc, contextAttribs ) );
    return ret;
}

}
}
}
