﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/util/ens_ResponseReader.h>

namespace nn { namespace ens { namespace detail { namespace util {

ResponseReader::ResponseReader() NN_NOEXCEPT
{
}

ResponseReader::~ResponseReader() NN_NOEXCEPT
{
}

bool ResponseReader::ResponseDumpCallback(const JsonPath& jsonPath, const DataHolder& holder, void* pParam) NN_NOEXCEPT
{
    NN_UNUSED(pParam);

    NN_DETAIL_ENS_INFO("%s\n", jsonPath.GetString());

    switch (holder.type)
    {
    case DataHolderType_Nil:
        {
            NN_DETAIL_ENS_INFO("    = nil\n");
        }
        break;
    case DataHolderType_Boolean:
        {
            NN_DETAIL_ENS_INFO("    = %s\n", holder.boolean ? "true" : "false");
        }
        break;
    case DataHolderType_Integer:
        {
            if (holder.integer.isSigned)
            {
                NN_DETAIL_ENS_INFO("    = %lld\n", holder.integer.s64);
            }
            else
            {
                NN_DETAIL_ENS_INFO("    = %llu\n", holder.integer.u64);
            }
        }
        break;
    case DataHolderType_Float:
        {
            NN_DETAIL_ENS_INFO("    = %f\n", holder.float64);
        }
        break;
    case DataHolderType_String:
        {
            NN_DETAIL_ENS_INFO("    = %.*s\n",
                static_cast<int>(std::min(holder.string.length, static_cast<size_t>(INT_MAX))), holder.string.pValue);
        }
        break;
    case DataHolderType_Binary:
        {
            NN_DETAIL_ENS_INFO("    = binary(length:%zu)\n", holder.binary.length);
        }
        break;
    case DataHolderType_Extension:
        {
            NN_DETAIL_ENS_INFO("    = extension(type=%d, length:%zu)\n", holder.extension.type, holder.extension.length);
        }
        break;
    default:
        break;
    }

    return true;
}

}}}}
