﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/core/ens_HttpConnectionProvider.h>

namespace nn { namespace ens { namespace detail { namespace core {

HttpConnectionProvider::HttpConnectionProvider() NN_NOEXCEPT
    : m_IsAcquired(false)
{
}

HttpConnectionProvider::~HttpConnectionProvider() NN_NOEXCEPT
{
}

void HttpConnectionProvider::Acquire() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(!m_IsAcquired);

    CURL* pHandle = m_Connection.GetHandle();

    if (!pHandle)
    {
        m_Connection.Initialize();

        m_IsAcquired = m_Connection.GetHandle() ? true : false;
    }
    else
    {
        m_Connection.Reset();

        m_IsAcquired = true;
    }
}

void HttpConnectionProvider::Release() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_IsAcquired);

    m_IsAcquired = false;
}

HttpConnection& HttpConnectionProvider::GetConnection() NN_NOEXCEPT
{
    return m_Connection;
}

}}}}
