﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/eft/eft2_Render.h>

namespace nw   {
namespace eft2 {


//---------------------------------------------------------------------------
//  描画命令を発行する
//---------------------------------------------------------------------------
void Render::DrawPrimitive( PrimitiveType primType, u32 vertexNum )
{
#ifdef EFT_OGL
    glDrawArrays( primType, 0, vertexNum );
#endif
#if EFT_GX2
    GX2Draw( static_cast<GX2PrimitiveType>(primType), vertexNum );
#endif
}

//---------------------------------------------------------------------------
//  描画命令を発行する
//---------------------------------------------------------------------------
void Render::DrawIndexedPrimitive( PrimitiveType primType, u32 vertexNum, const void* indexPtr )
{
#ifdef EFT_OGL
    glDrawElements( primType, vertexNum, GL_UNSIGNED_INT, indexPtr );
#endif
#if EFT_GX2
    GX2DrawIndexed( static_cast<GX2PrimitiveType>(primType), vertexNum, GX2_INDEX_FORMAT_U32, indexPtr );
#endif
}

//---------------------------------------------------------------------------
//  描画命令を発行する
//---------------------------------------------------------------------------
void Render::DrawInstanceIndexedPrimitive( PrimitiveType primType, u32 vertexNum, const void* indexPtr, u32 primCount )
{
#if defined( EFT_OGL ) && defined( EFT_USE_INSTANS_DRAW )
    glDrawElementsInstanced( primType, vertexNum, GL_UNSIGNED_INT, indexPtr, primCount );
#elif EFT_GX2
    GX2DrawIndexedEx( static_cast<GX2PrimitiveType>(primType), vertexNum, GX2_INDEX_FORMAT_U32, indexPtr, 0, primCount );
#else
    EFT_UNUSED_VARIABLE( primType );
    EFT_UNUSED_VARIABLE( vertexNum );
    EFT_UNUSED_VARIABLE( indexPtr );
    EFT_UNUSED_VARIABLE( primCount );
#endif
}

//---------------------------------------------------------------------------
//  描画命令を発行する
//---------------------------------------------------------------------------
void Render::DrawPrimitive( PrimitiveType primType, u32 startNum, u32 vertexNum )
{
#ifdef EFT_OGL
    glDrawArrays( primType, startNum, vertexNum );
#elif EFT_GX2
    GX2DrawEx( static_cast<GX2PrimitiveType>(primType), vertexNum, startNum, 1 );
#else
    EFT_UNUSED_VARIABLE( primType );
    EFT_UNUSED_VARIABLE( startNum );
    EFT_UNUSED_VARIABLE( vertexNum );
#endif
}

//---------------------------------------------------------------------------
//  描画命令を発行する
//---------------------------------------------------------------------------
void Render::DrawInstancePrimitive( PrimitiveType primType, u32 vertexNum, u32 primCount )
{
#if defined( EFT_OGL ) && defined( EFT_USE_INSTANS_DRAW )
    glDrawArraysInstanced( primType, 0, vertexNum, primCount );
#elif EFT_GX2
    GX2DrawEx( static_cast<GX2PrimitiveType>(primType), vertexNum, 0, primCount );
#else
    EFT_UNUSED_VARIABLE( primType );
    EFT_UNUSED_VARIABLE( vertexNum );
    EFT_UNUSED_VARIABLE( primCount );
#endif
}

//---------------------------------------------------------------------------
//  描画命令を発行する
//---------------------------------------------------------------------------
void Render::DrawBaseInstancePrimitive( PrimitiveType primType, u32 vertexNum, const void* indexPtr, u32 primCount, u32 baseVertexNum )
{
#if defined( EFT_OGL ) && defined( EFT_USE_INSTANS_DRAW )
    glDrawElementsInstancedBaseInstance( primType, vertexNum, GL_UNSIGNED_INT, indexPtr, primCount, baseVertexNum );
#elif EFT_GX2
#if ( CAFE_OS_SDK_VERSION >= 21201 )
    GX2DrawIndexedEx2( static_cast<GX2PrimitiveType>(primType),
        vertexNum,
        GX2_INDEX_FORMAT_U32,
        indexPtr,
        0,
        1,
        baseVertexNum );
#else
    GX2DrawIndexedEx( static_cast<GX2PrimitiveType>(primType),
        vertexNum,
        GX2_INDEX_FORMAT_U32,
        indexPtr,
        baseVertexNum,
        primCount );
#endif
#else
    EFT_UNUSED_VARIABLE( primType );
    EFT_UNUSED_VARIABLE( vertexNum );
    EFT_UNUSED_VARIABLE( indexPtr );
    EFT_UNUSED_VARIABLE( primCount );
    EFT_UNUSED_VARIABLE( baseVertexNum );
#endif
}

} // namespace eft2
} // namespace nw

