﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

namespace nn{ namespace capsrv{ namespace server{

    nn::Result InitializeForScreenShotServer(nn::os::ThreadType* pScreenShotWorkerThread) NN_NOEXCEPT;

    void FinalizeForScreenShotServer() NN_NOEXCEPT;

    // ScreenShotControlServer(caps:sc) 用スレッドの関数。
    // @param[in] pUnused 参照されないため nullptr で構わない。
    void ScreenShotControlServerThreadFunction(void* pUnused) NN_NOEXCEPT;

    // ScreenShotControlServer(caps:sc) 用リアルタイムスレッドの関数。
    // @param[in] pUnused 参照されないため nullptr で構わない。
    void ScreenShotControlRealtimeServerThreadFunction(void* pUnused) NN_NOEXCEPT;

    // ScreenShotServer(caps:ss) 用スレッドの関数。
    // @param[in] pUnused 参照されないため nullptr で構わない。
    void ScreenShotServerThreadFunction(void* pUnused) NN_NOEXCEPT;

    // ScreenShotWorker 用スレッドの関数。
    // @param[in] pUnused 参照されないため nullptr で構わない。
    void ScreenShotWorkerThreadFunction(void* pUnused) NN_NOEXCEPT;

}}}
