﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

namespace nn{ namespace capsrv{ namespace server{

    class ScreenShotWorker
    {
    public:
        static const uintptr_t StopRequestedWaitHolderTag = 0x0001;

    public:
        ScreenShotWorker() NN_NOEXCEPT;

        nn::Result Initialize(nn::os::ThreadType* pScreenShotWorkerThread) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void RunWorker() NN_NOEXCEPT;
        void StopWorker() NN_NOEXCEPT;

        void BeginBoostingWorkerThreadPriority() NN_NOEXCEPT;
        void EndBoostingWorkerThreadPriority() NN_NOEXCEPT;

    private:
        nn::os::EventType m_IsIdleEvent;
        nn::os::EventType m_IsStopRequestedEvent;

        nn::os::MultiWaitType       m_MultiWait;
        nn::os::MultiWaitHolderType m_StopRequestedEventWaitHolder;

        std::atomic<nn::os::ThreadType*> m_pWorkerThread;
    };

}}}
