﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ScreenShotControlServerManager.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/sf/capsrv_ServiceName.h>

namespace nn{ namespace capsrv{ namespace server{

#if defined(NN_CAPSRV_USE_HIPC)

    nn::Result ScreenShotControlServerManager::Initialize() NN_NOEXCEPT
    {
        m_ServiceHolder.emplace();
        m_RealtimeServerManager.emplace();
        m_ServerManager.emplace(&m_RealtimeServerManager.value());

        NN_ABORT_UNLESS_RESULT_SUCCESS(m_ServerManager->RegisterObjectForPort(
            m_ServiceHolder->GetShared(),
            SessionCountMax,
            sf::ScreenShotControlServiceName
        ));

        nn::os::InitializeEvent(&m_IsIdleEvent, true, nn::os::EventClearMode_ManualClear);

        NN_RESULT_SUCCESS;
    }

    void ScreenShotControlServerManager::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(nn::os::TryWaitEvent(&m_IsIdleEvent));
        nn::os::FinalizeEvent(&m_IsIdleEvent);
        m_ServerManager = nn::util::nullopt;
        m_RealtimeServerManager = nn::util::nullopt;
        m_ServiceHolder = nn::util::nullopt;
    }

    void ScreenShotControlServerManager::StartServer() NN_NOEXCEPT
    {
        m_RealtimeServerManager->Start();
        m_ServerManager->Start();
    }

    void ScreenShotControlServerManager::StopServer() NN_NOEXCEPT
    {
        m_ServerManager->RequestStop();
        m_RealtimeServerManager->RequestStop();
        nn::os::WaitEvent(&m_IsIdleEvent);
    }

    void ScreenShotControlServerManager::RunServer() NN_NOEXCEPT
    {
        // TORIAEZU:
        // 排他としては不十分だが実用上問題ない。
        NN_ABORT_UNLESS(nn::os::TryWaitEvent(&m_IsIdleEvent));
        nn::os::ClearEvent(&m_IsIdleEvent);

        m_ServerManager->LoopAuto();

        nn::os::SignalEvent(&m_IsIdleEvent);
    }

    void ScreenShotControlServerManager::RunRealtimeServer() NN_NOEXCEPT
    {
        // TORIAEZU:
        // m_IsIdleEvent は触らないでおく
        //NN_ABORT_UNLESS(nn::os::TryWaitEvent(&m_IsIdleEvent));
        //nn::os::ClearEvent(&m_IsIdleEvent);

        m_RealtimeServerManager->LoopAuto();

        //nn::os::SignalEvent(&m_IsIdleEvent);
    }

    nn::sf::HipcServerSessionManagerCommonBase* ScreenShotControlServerManager::IpcServerManager::GetHipcServerSessionManagerCommonBase(uint32_t tag) NN_NOEXCEPT
    {
        switch (tag)
        {
            case 1: return m_pRealtimeServerManager;
            default: return this;
        }
    }

#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)

    nn::Result ScreenShotControlServerManager::Initialize() NN_NOEXCEPT
    {
        m_ServiceHolder.emplace();
        NN_RESULT_SUCCESS;
    }

    void ScreenShotControlServerManager::Finalize() NN_NOEXCEPT
    {
        m_ServiceHolder = nn::util::nullopt;
    }

    nn::sf::SharedPointer<nn::capsrv::sf::IScreenShotControlService> ScreenShotControlServerManager::GetPointer() NN_NOEXCEPT
    {
        return m_ServiceHolder->GetShared();
    }

#endif

}}}
