﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "visrv_ScreenShotServerObject.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    nn::Result AcquireScreenShotContextImpl(ScreenShotContext** pOutContext) NN_NOEXCEPT;
    nn::Result ResumeScreenShotContextImpl(ScreenShotContext** pOutContext, ScreenShotContextSuspendedTask task) NN_NOEXCEPT;
    void ReleaseScreenShotContextImpl(ScreenShotContext* pContext) NN_NOEXCEPT;

}}}}

// ScreenShotContext を獲得して指定した引数に代入する
// - 復旧が必要な Context があった場合復旧を試みる
// - 獲得した Context はスコープを抜ける際に自動的に解放される
//   - 解放する際に、復旧が必要かを判定して即座に Release するか復旧待ちにするか決められる
#define NN_CAPSRV_SERVER_SCREENSHOT_CONTEXT(var) \
    nn::capsrv::server::ScreenShotContext* var; \
    NN_RESULT_DO(nn::capsrv::server::detail::AcquireScreenShotContextImpl(&var)); \
    NN_RESULT_THROW_UNLESS(var != nullptr, nn::capsrv::ResultScreenShotCaptureFailed()); \
    NN_UTIL_SCOPE_EXIT { nn::capsrv::server::detail::ReleaseScreenShotContextImpl(pContext); };

#define NN_CAPSRV_SERVER_RESUME_SCREENSHOT_CONTEXT(var,task) \
    nn::capsrv::server::ScreenShotContext* var; \
    NN_RESULT_DO(nn::capsrv::server::detail::ResumeScreenShotContextImpl(&var, task)); \
    NN_RESULT_THROW_UNLESS(var != nullptr, nn::capsrv::ResultScreenShotCaptureFailed()); \
    NN_UTIL_SCOPE_EXIT { nn::capsrv::server::detail::ReleaseScreenShotContextImpl(pContext); };
