﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>

namespace nn{ namespace capsrv{ namespace server{

    class ScreenShotApplicationServiceImpl
    {
    public:
        nn::Result SaveScreenShot(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::ScreenShotSizeType size, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
        nn::Result SaveScreenShotEx0(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::detail::ScreenShotAttributeEx0 attribute, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;
        nn::Result SaveScreenShotEx2(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::sf::InBuffer& imageBuffer, nn::capsrv::detail::ScreenShotAttributeEx0 attribute, const nn::capsrv::UserIdList& userIdList, nn::applet::AppletResourceUserId aruid, nn::capsrv::OverlayNotificationRequestType overlayRequest) NN_NOEXCEPT;

    private:
        nn::Result SaveScreenShotImpl(
            nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry,
            const nn::sf::InBuffer& imageBuffer,
            const nn::capsrv::detail::ScreenShotAttributeEx0& attribute,
            const nn::capsrv::UserIdList& userIdList,
            nn::applet::AppletResourceUserId aruid,
            nn::capsrv::OverlayNotificationRequestType overlayRequest
        ) NN_NOEXCEPT;
    };

}}}
