﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SaveApplicationScreenShot.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "visrv_ScreenShotContext.h"
#include "action/visrv_GetApplicationIdFromAruid.h"
#include "action/visrv_GenerateAlbumFileId.h"
#include "action/visrv_GenerateApplicationAlbumEntry.h"
#include "action/visrv_DownsampleRgbaForViewerThumbnail.h"
#include "action/visrv_EncodeViewerThumbnailJpeg.h"
#include "action/visrv_CreateExifBuilder.h"
#include "action/visrv_EncodeScreenShotJpegRgba.h"
#include "action/visrv_CalculateMakerNoteRange.h"
#include "action/visrv_SaveScreenShotFile.h"
#include "action/visrv_DownsampleForOverlayThumbnailFromViewerThumbnail.h"
#include "action/visrv_SetOverlayScreenShotThumbnail.h"
#include "action/visrv_NotifyScreenShotResultToOverlayDisp.h"
#include "action/visrv_NotifyThumbnailReadyToOverlayDisp.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    namespace {
        nn::Result SaveApplicationScreenShotAruidImpl(ScreenShotContext& context) NN_NOEXCEPT
        {
            NN_RESULT_DO(action::GetApplicationIdFromAruid(context));
            NN_RESULT_DO(action::GenerateAlbumFileId(context));

            // PhotoViewer 用サムネイルを作成
            NN_RESULT_DO(action::DownsampleRgbaForViewerThumbnail(context));
            NN_RESULT_DO(action::EncodeViewerThumbnailJpeg(context));

            // Viewer 用サムネイルを変換してオーバーレイ用サムネイルを作成
            OverlayNotificationRequestType overlayRequest = {};
            {
                NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
                NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, OverlayNotificationRequest);
                NN_CAPSRV_SCREENSHOT_CONTEXT_GET(request, context, OverlayNotificationRequest);
                overlayRequest = request;
            }
            if(overlayRequest != OverlayNotificationRequest_None)
            {
                NN_RESULT_DO(action::DownsampleForOverlayThumbnailFromViewerThumbnail(context));
                NN_RESULT_DO(action::SetOverlayScreenShotThumbnail(context));
                NN_RESULT_DO(action::NotifyThumbnailReadyToOverlayDisp(context));
            }

            // Jpeg データ作成
            {
                NN_RESULT_DO(action::CreateExifBuilder(context));
                NN_UTIL_SCOPE_EXIT{ action::DestroyExifBuilder(context); }; // エンコードしたら破棄する

                NN_RESULT_DO(action::EncodeScreenShotJpegRgba(context));
            }

            NN_RESULT_DO(action::CalculateMakerNoteRange(context));
            NN_RESULT_DO(action::SaveScreenShotFile(context));
            NN_RESULT_DO(action::GenerateApplicationAlbumEntry(context));

            NN_RESULT_SUCCESS;
        }
    }

    nn::Result SaveApplicationScreenShotAruid(ScreenShotContext& context) NN_NOEXCEPT
    {
        auto result = SaveApplicationScreenShotAruidImpl(context);
        {
            NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
            NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, Result);
            NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, Result, result);
        }
        NN_RESULT_DO(action::NotifyScreenShotReultToOverlayDisp(context));
        return result;
    }



}}}}
