﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_AlbumControl.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_Result.h>
#include "../../detail/capsrvServer_GetApplicationAlbumEntry.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // ApplicationAlbumEntry を取得する
    // @param[in]  context.AlbumFileId
    // @param[in]  context.FileSize
    // @param[out] context.ApplicationAlbumEntry
    static nn::Result GenerateApplicationAlbumEntry(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, AlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, FileSize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, ApplicationAlbumEntry);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("AppEntry  ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileId, context, AlbumFileId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileSize, context, FileSize);
        AlbumEntry srcEntry = {};
        srcEntry.fileId = fileId;
        srcEntry.size   = fileSize;

        ApplicationAlbumEntry dstEntry = {};
        NN_RESULT_TRY(nn::capsrv::GenerateApplicationAlbumEntry(&dstEntry, srcEntry, srcEntry.fileId.applicationId))
            NN_RESULT_CATCH_ALL
            {
                NN_RESULT_THROW(ResultAlbumError());
            }
        NN_RESULT_END_TRY;

        NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, ApplicationAlbumEntry, dstEntry);
        NN_RESULT_SUCCESS;
    }

}}}}}
