﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_JpegDestinationMgrBase.h"

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    namespace detail{

        JpegDestinationMgrImpl::JpegDestinationMgrImpl(JpegDestinationMgrBase* pBase) NN_NOEXCEPT
        {
            this->jpeg_destination_mgr::next_output_byte    = nullptr;
            this->jpeg_destination_mgr::free_in_buffer      = 0;
            this->jpeg_destination_mgr::init_destination    = OnInitDestination;
            this->jpeg_destination_mgr::empty_output_buffer = OnEmptyOutputBuffer;
            this->jpeg_destination_mgr::term_destination    = OnTermDestination;
            m_TotalBufferSize  = 0;
            m_TotalWrittenSize = 0;
            m_pBase = pBase;
        }


        void JpegDestinationMgrImpl::OnInitDestination(j_compress_ptr cinfo) NN_NOEXCEPT
        {
            auto pSelf = reinterpret_cast<SelfType*>(cinfo->dest);
            void* buffer = nullptr;
            size_t size = 0;
            pSelf->m_pBase->Open(&buffer, &size, cinfo);
            if(buffer == nullptr || size == 0)
            {
                OnOutOfMemory(cinfo);
            }
            pSelf->jpeg_destination_mgr::next_output_byte = reinterpret_cast<JOCTET*>(buffer);
            pSelf->jpeg_destination_mgr::free_in_buffer = size;
            pSelf->m_TotalBufferSize = size;
        }

        boolean JpegDestinationMgrImpl::OnEmptyOutputBuffer(j_compress_ptr cinfo) NN_NOEXCEPT
        {
            auto pSelf = reinterpret_cast<SelfType*>(cinfo->dest);
            void* buffer = nullptr;
            size_t size = 0;
            pSelf->m_pBase->GetNextBuffer(&buffer, &size, cinfo);
            if(buffer == nullptr || size == 0)
            {
                OnOutOfMemory(cinfo);
            }
            pSelf->jpeg_destination_mgr::next_output_byte = reinterpret_cast<JOCTET*>(buffer);
            pSelf->jpeg_destination_mgr::free_in_buffer = size;
            pSelf->m_TotalBufferSize += size;
            return true;
        }

        void JpegDestinationMgrImpl::OnTermDestination(j_compress_ptr cinfo) NN_NOEXCEPT
        {
            auto pSelf = reinterpret_cast<SelfType*>(cinfo->dest);
            pSelf->m_TotalWrittenSize = pSelf->m_TotalBufferSize - pSelf->jpeg_destination_mgr::free_in_buffer;
            pSelf->m_pBase->Close(cinfo);
            pSelf->jpeg_destination_mgr::next_output_byte = nullptr;
            pSelf->jpeg_destination_mgr::free_in_buffer = 0;
        }

        void JpegDestinationMgrImpl::OnOutOfMemory(j_compress_ptr cinfo) NN_NOEXCEPT
        {
            typedef JpegEncoderType::j_common_ptr j_common_ptr;
            ERREXIT1(cinfo, JpegEncoderType::J_MESSAGE_CODE::JERR_OUT_OF_MEMORY, OUT_OF_MEM_REASON_OUTPUT);
        }

        size_t JpegDestinationMgrImpl::GetWrittenSize() const NN_NOEXCEPT
        {
            return m_TotalWrittenSize;
        }
    }

    //---------------------------------------

    JpegDestinationMgrBase::JpegDestinationMgrBase() NN_NOEXCEPT
        : m_Impl(this)
    {
    }

    JpegEncoderType::jpeg_destination_mgr* JpegDestinationMgrBase::Get() NN_NOEXCEPT
    {
        return &m_Impl;
    }

    void JpegDestinationMgrBase::Open(void**, size_t*, j_compress_ptr cinfo) NN_NOEXCEPT
    {
        AbortByOutOfMemory(cinfo);
    }

    void JpegDestinationMgrBase::Close(j_compress_ptr) NN_NOEXCEPT
    {
    }

    void JpegDestinationMgrBase::GetNextBuffer(void**, size_t*, j_compress_ptr cinfo) NN_NOEXCEPT
    {
        AbortByOutOfMemory(cinfo);
    }

    void JpegDestinationMgrBase::AbortByOutOfMemory(j_compress_ptr cinfo) NN_NOEXCEPT
    {
        detail::JpegDestinationMgrImpl::OnOutOfMemory(cinfo);
    }

    size_t JpegDestinationMgrBase::GetWrittenSize() const NN_NOEXCEPT
    {
        return m_Impl.GetWrittenSize();
    }

}}}}
