﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    struct SoftwareJpegDecoderBufferOutputInfo
    {
        int* pOutWidth;
        int* pOutHeight;
        void* pBuffer;
        size_t bufferSize;
    };

    struct SoftwareJpegDecoderBufferInputInfo
    {
        const void* pBuffer;
        size_t bufferSize;
        // 期待される幅(px)
        int width;
        // 期待される高さ(px)
        int height;
        // do_fancy_upsampling
        bool isFancyUpsamplingEnabled;
        // do_block_smoothing
        bool isBlockSmoothingEnabled;
    };

    class SoftwareJpegDecoderRgba8
    {
    public:
        static nn::Result DecodeRgba8BufferFromBuffer(
            SoftwareJpegDecoderBufferOutputInfo& outputInfo,
            const SoftwareJpegDecoderBufferInputInfo& inputInfo,
            void* pWorkBuffer,
            size_t workBufferSize
        ) NN_NOEXCEPT;
    };

}}}}

