﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/ovln/format/ovln_CapsrvMessage.h>
#include <nn/ovln/ovln_SenderForOverlay.h>

namespace nn{ namespace capsrv{ namespace server{

    class OverlayNotifier
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        nn::Result SendToOverlay(const nn::ovln::format::ScreenShotCapturedData& data) NN_NOEXCEPT;

    private:
        nn::ovln::SenderForOverlayType m_Sender;
        nn::os::SdkMutexType m_Mutex;
    };

}}}
