﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_ScreenShotAttribute.h>
#include "capsrvServer_MakerNoteInfo.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    class ScreenShotAttributeUtility
    {
    public:
        static nn::Result ConvertToMakerNoteInfo(
            MakerNoteInfo* pOutValue,
            MakerNoteVersionType makerNoteVersion,
            EncryptedApplicationId applicationId,
            AlbumFileDateTime dateTime,
            const nn::capsrv::ScreenShotAttribute& src,
            AppletData* pAppletData,
            ApplicationData* pApplicationData,
            SystemReservedInfo* pSystemReservedInfo
        ) NN_NOEXCEPT;

        static nn::Result ConvertFromMakerNoteInfo(
            nn::capsrv::ScreenShotAttribute* pOutValue,
            const MakerNoteInfo& src
        ) NN_NOEXCEPT;

    public:
        static nn::Result ImportAttribute(
            nn::capsrv::ScreenShotAttribute* pOutAttribute,
            const nn::capsrv::detail::ScreenShotAttributeEx0& src,
            nn::capsrv::AlbumFileDescriptionType description
        ) NN_NOEXCEPT
        {
            NN_STATIC_ASSERT(sizeof(ScreenShotAttribute) == sizeof(nn::capsrv::detail::ScreenShotAttributeEx0));
            ScreenShotAttribute attribute;
            std::memcpy(&attribute, &src, sizeof(attribute));

            // description を上書き
            attribute.description = description;

            *pOutAttribute = attribute;
            NN_RESULT_SUCCESS;
        }

        static nn::Result GetScreenShotAttributeFromOriginalAttribute(
            nn::capsrv::ScreenShotAttribute* pOutAttribute,
            const nn::capsrv::detail::ScreenShotAttributeEx0& originalAttribute,
            nn::capsrv::AlbumFileDescriptionType description
        ) NN_NOEXCEPT
        {
            NN_STATIC_ASSERT(sizeof(ScreenShotAttribute) == sizeof(nn::capsrv::detail::ScreenShotAttributeEx0));
            ScreenShotAttribute attribute;
            std::memcpy(&attribute, &originalAttribute, sizeof(attribute));

            // description を上書き
            attribute.description = nn::capsrv::AlbumFileDescription_ScreenShotEdited;
            FillMovieAttributesForScreenShot(attribute);
            *pOutAttribute = attribute;
            NN_RESULT_SUCCESS;
        }

        static ScreenShotAttribute GetScreenShotAttribute(
            nn::capsrv::AlbumFileDescriptionType description,
            ScreenShotSizeType size,
            ScreenShotOrientationType orientation
        ) NN_NOEXCEPT
        {
            ScreenShotAttribute attribute = {};
            attribute.description = description;
            attribute.size = size;
            attribute.orientation = orientation;
            FillMovieAttributesForScreenShot(attribute);
            FillUneditableAreaNone(attribute);
            return attribute;
        }


    private:
        // 動画用フィールドを静止画用の既定値で埋めます。
        static void FillMovieAttributesForScreenShot(
            ScreenShotAttribute& attribute
        ) NN_NOEXCEPT
        {
            attribute.movieSize                = nn::capsrv::ScreenShotSize_Default;
            attribute.frameCount               = 1;
            attribute.frameRateNumerator       = 0;
            attribute.frameRateDenominator     = 0;
            attribute.dataDurationMilliseconds = 0;
            attribute.keyFrameInterval         = 0;
        }

        // 編集不可範囲フィールドを指定なしとして埋めます。
        static void FillUneditableAreaNone(
            ScreenShotAttribute& attribute
        ) NN_NOEXCEPT
        {
            attribute.uneditableAreaCoordinateX = 0;
            attribute.uneditableAreaCoordinateY = 0;
            attribute.uneditableAreaWidth       = 0;
            attribute.uneditableAreaHeight      = 0;
            NN_SDK_ASSERT(!attribute.HasUneditableArea());
        }
    };

}}}}
