﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_ParseLayerStackName.h"

#include <nn/util/util_StringUtil.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include "../capsrvServer_Config.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    nn::vi::LayerStack ParseLayerStackName(const char* name, CaptureUsage usage) NN_NOEXCEPT
    {
        if(nn::util::Strncmp("screenshot", name, LayerStackNameSize) == 0)
        {
            return nn::vi::LayerStack_Screenshot;
        }
        else if(nn::util::Strncmp("lastframe", name, LayerStackNameSize) == 0)
        {
            return nn::vi::LayerStack_LastFrame;
        }
        else if(nn::util::Strncmp("physical", name, LayerStackNameSize) == 0)
        {
            return nn::vi::LayerStack_Default;
        }

        char safeName[LayerStackNameSize] = {};
        nn::util::Strlcpy(safeName, name, sizeof(safeName));
        switch(usage)
        {
        case CaptureUsage_ScreenShot:
            NN_CAPSRV_LOG_WARN("unknown layerstack \"%s\". default layerstack \"%s\" is used.\n", safeName, "screenshot");
            return DefaultScreenShotLayerStack;
        case CaptureUsage_LastFrame:
            NN_CAPSRV_LOG_WARN("unknown layerstack \"%s\". default layerstack \"%s\" is used.\n", safeName, "lastframe");
            return DefaultLastFrameLayerStack;
        default: NN_UNEXPECTED_DEFAULT;
        }
    }

}}}}
