﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/os.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>
#include "../capsrvServer_Config.h"
#include "decodersrv_DecoderControlServiceImpl.h"

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcServer.h>

namespace nn{ namespace capsrv{ namespace server{

    class DecoderControlServerManager
    {
    public:
        static const uint32_t   SessionCountMax = 1;
        static const int        PortCountMax    = 1;

        typedef nn::sf::UnmanagedServiceObject<nn::capsrv::sf::IDecoderControlService, DecoderControlServiceImpl> ServiceHolderType;
        typedef nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax, PortCountMax> ServerManagerType;

    public:
        nn::Result Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void StartServer() NN_NOEXCEPT;
        void StopServer() NN_NOEXCEPT;

        void RunServer() NN_NOEXCEPT;

    private:
        nn::util::optional<ServiceHolderType> m_ServiceHolder;
        nn::util::optional<ServerManagerType> m_ServerManager;
        nn::os::EventType                     m_IsIdleEvent;
    };

}}}
