﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_ResourceIdManager.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn{ namespace capsrv{ namespace server{

    ResourceIdType ResourceIdManager::GetInvalidResourceId() NN_NOEXCEPT
    {
        return 0;
    }

    void ResourceIdManager::Initialize() NN_NOEXCEPT
    {
        m_NextResourceId = GetInvalidResourceId() + 1;
    }

    void ResourceIdManager::Finalize() NN_NOEXCEPT
    {
        m_NextResourceId = GetInvalidResourceId() + 1;
    }

    ResourceIdType ResourceIdManager::AcquireResourceId() NN_NOEXCEPT
    {
        return m_NextResourceId++;
    }

    void ResourceIdManager::ReleaseResourceId(ResourceIdType id) NN_NOEXCEPT
    {
        NN_UNUSED(id);
    }

}}}

