﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_InitializeForAlbumServer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_Result.h>

#include "albumsrv/capsrvServer_AlbumServerObject.h"


#define NN_CAPSRV_STRONG_REQUIRES(expr) \
    NN_SDK_REQUIRES(expr);  \
    NN_ABORT_UNLESS(expr);

namespace nn{ namespace capsrv{ namespace server{

    namespace {
        bool g_IsInitialized = false;
    }

    nn::Result InitializeForAlbumServer() NN_NOEXCEPT
    {
        NN_CAPSRV_STRONG_REQUIRES(!g_IsInitialized);

        std::memset(&g_AlbumWorkMemory, 0, sizeof(g_AlbumWorkMemory));

        // EnvironmentInfo
        g_EnvironmentInfo.Initialize();

        // ResourceIdManager
        g_ResourceIdManager.Initialize();

        // AlbumErrorConverter
        g_AlbumErrorConverter.Initialize();

        // AlbumMovieUtility
        g_AlbumMovieUtilityStaticObject.Initialize(g_AlbumWorkMemory.albumManagerMemory, AlbumWorkMemorySize_AlbumManagerWorkBuffer);

        // AlbumManager
        {
            g_AlbumManager.SetWorkMemory(g_AlbumWorkMemory.albumManagerMemory, AlbumWorkMemorySize_AlbumManagerWorkBuffer);
            g_AlbumManager.Initialize(&g_EnvironmentInfo, &g_ResourceIdManager);
        }

        // AlbumFileIdGenerator
        g_AlbumFileIdGenerator.Initialize();

        // ThumbnailHolder
        {
            g_OverlayThumbnailHolder.SetMemory(g_AlbumWorkMemory.overlayThumbnailHolderMemory, AlbumWorkMemorySize_OverlayThumbnailHolderMemory);
            g_OverlayThumbnailHolder.Initialize();
        }

        // ApplicationResourceManager
        g_ApplicationResourceManager.Initialize();

        NN_ABORT_UNLESS_RESULT_SUCCESS(g_AlbumControlServerManager.Initialize());
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_AlbumServerManager.Initialize());

        g_AlbumControlServerManager.StartServer();
        g_AlbumServerManager.StartServer();

        // NAND を有効化
        {
            g_AlbumManager.ResetMountStatus(AlbumStorage_Nand);
            g_AlbumManager.RefreshStorageCache(AlbumStorage_Nand);
        }
        g_IsInitialized = true;
        NN_RESULT_SUCCESS;
    }

    void FinalizeForAlbumServer() NN_NOEXCEPT
    {
        NN_CAPSRV_STRONG_REQUIRES(g_IsInitialized);

        // ServerManager: Worker, Queue よりも先に Finalize すること
        g_AlbumServerManager.StopServer();
        g_AlbumControlServerManager.StopServer();
        g_AlbumServerManager.Finalize();
        g_AlbumControlServerManager.Finalize();

        // Other:
        g_ApplicationResourceManager.Finalize();
        g_OverlayThumbnailHolder.Finalize();
        g_AlbumFileIdGenerator.Finalize();
        g_AlbumManager.Finalize();
        g_AlbumMovieUtilityStaticObject.Finalize();
        g_AlbumErrorConverter.Finalize();
        g_ResourceIdManager.Finalize();
        g_EnvironmentInfo.Finalize();

        g_IsInitialized = false;
    }

    void AlbumControlServerThreadFunction(void*) NN_NOEXCEPT
    {
        NN_CAPSRV_STRONG_REQUIRES(g_IsInitialized);
        g_AlbumControlServerManager.RunServer();
    }

    void AlbumServerThreadFunction(void*) NN_NOEXCEPT
    {
        NN_CAPSRV_STRONG_REQUIRES(g_IsInitialized);
        g_AlbumServerManager.RunServer();
    }

}}}
