﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_AlbumStorage.h>
#include <nn/capsrv/capsrv_AlbumFileContents.h>
#include "detail/capsrvServer_MakerNoteInfo.h"

#include <memory>

namespace nn{ namespace capsrv{ namespace server{

    class EnvironmentInfo
    {
    public:
        EnvironmentInfo() NN_NOEXCEPT;

#ifdef ALBUMSYNC_IS_PUBLICTOOL
        static EnvironmentInfo GetValueForPublicTool() NN_NOEXCEPT
        {
            EnvironmentInfo value;
            value.m_IsRawScreenShotReadStreamEnabled = false;
            value.m_IsAlbumScreenShotFileSupported   = true;
            value.m_IsAlbumMovieFileSupported        = false;
            return value;
        }
#endif

#ifdef ALBUMSYNC_IS_PRIVATETOOL
        static EnvironmentInfo GetValueForPrivateTool() NN_NOEXCEPT
        {
            EnvironmentInfo value;
            value.m_IsRawScreenShotReadStreamEnabled = false;
            value.m_IsAlbumScreenShotFileSupported   = true;
            value.m_IsAlbumMovieFileSupported        = true;
            return value;
        }
#endif

#ifdef NNT_CAPSRV_ENABLE_TESTMODE
        static EnvironmentInfo GetValue(
            bool isRawScreenShotReadStreamEnabled,
            bool isAlbumScreenShotFileSupported,
            bool isAlbumMovieFileSupported
        ) NN_NOEXCEPT
        {
            EnvironmentInfo value;
            value.m_IsRawScreenShotReadStreamEnabled = isRawScreenShotReadStreamEnabled;
            value.m_IsAlbumScreenShotFileSupported = isAlbumScreenShotFileSupported;
            value.m_IsAlbumMovieFileSupported = isAlbumMovieFileSupported;
            return value;
        }
#endif

        void SetDefault() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsRawScreenShotReadStreamEnabled() const NN_NOEXCEPT;

        bool IsAlbumScreenShotFileSupported() const NN_NOEXCEPT;
        bool IsAlbumMovieFileSupported() const NN_NOEXCEPT;
        bool IsAlbumExtraScreenShotFileSupported() const NN_NOEXCEPT;
        bool IsAlbumExtraMovieFileSupported() const NN_NOEXCEPT;
        bool IsAlbumExtraMovieFileSupportedForNandStorage() const NN_NOEXCEPT;

        bool IsAlbumFileContentsSupported(AlbumFileContentsType contents) const NN_NOEXCEPT;

        bool IsAlbumScreenShotFileDataVerificationEnabled() const NN_NOEXCEPT;
        bool IsAlbumMovieFileSignVerificationEnabled() const NN_NOEXCEPT;
        bool IsAlbumMovieFileHashVerificationEnabled() const NN_NOEXCEPT;

        detail::MakerNoteVersionType GetMakerNoteVersion() const NN_NOEXCEPT;
        int64_t GetFileCountLimit(AlbumStorageType storage, AlbumFileContentsType contents) const NN_NOEXCEPT;

        const char* GetPcHostAlbumDirectoryPath() const NN_NOEXCEPT;

        void Dump() const NN_NOEXCEPT;

    private:
        bool m_IsProdMode;
        bool m_IsRawScreenShotReadStreamEnabled;
        bool m_IsAlbumScreenShotFileSupported;
        bool m_IsAlbumMovieFileSupported;

        bool m_IsAlbumScreenShotFileDataVerificationEnabled;
        bool m_IsAlbumMovieFileSignVerificationEnabled;
        bool m_IsAlbumMovieFileHashVerificationEnabled;

        detail::MakerNoteVersionType m_MakerNoteVersion;

        int64_t m_NandScreenShotFileCountLimit;
        int64_t m_NandMovieFileCountLimit;
        int64_t m_SdScreenShotFileCountLimit;
        int64_t m_SdMovieFileCountLimit;

        std::unique_ptr<const char[]> m_pPcHostAlbumDirectoryPath;
    };

}}}
