﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>

namespace nn{ namespace capsrv{ namespace server{

    class AlbumServiceImpl
    {
    public:
        nn::Result GetAlbumFileCount(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumFileList(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result LoadAlbumFile(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result DeleteAlbumFile(const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result StorageCopyAlbumFile(const nn::capsrv::AlbumFileId& sourceFileId, nn::capsrv::AlbumStorageType destinationStorage) NN_NOEXCEPT;
        nn::Result IsAlbumMounted(nn::sf::Out<bool> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumMountResult(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumUsage(nn::sf::Out<nn::capsrv::detail::AlbumUsage2> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumUsage3(nn::sf::Out<nn::capsrv::detail::AlbumUsage3> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumUsage16(nn::sf::Out<nn::capsrv::detail::AlbumUsage16> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsMask) NN_NOEXCEPT;

        nn::Result GetAlbumFileCountEx0(nn::sf::Out<std::uint64_t> outCount, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsFlag) NN_NOEXCEPT;
        nn::Result GetAlbumFileListEx0(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutArray<nn::capsrv::AlbumEntry>& pOutList, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsFlag contentsFlag) NN_NOEXCEPT;

        nn::Result GetAlbumFileSize(nn::sf::Out<std::uint64_t> outSize, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result LoadAlbumFileThumbnail(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImage(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result GetAlbumEntryFromApplicationAlbumEntry(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, const nn::ncm::ApplicationId& applicationId) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImageEx(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result SaveEditedScreenShot(nn::sf::Out<nn::capsrv::AlbumEntry> outFileEntry, const nn::sf::InBuffer& imageBuffer, const nn::sf::InBuffer& thumbnailBuffer, std::int64_t imageWidth, std::int64_t imageHeight, std::int64_t thumbnailWidth, std::int64_t thumbnailHeight, const nn::capsrv::AlbumFileId& originalFileId) NN_NOEXCEPT;
        nn::Result GetLastOverlayScreenShotThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result GetLastOverlayMovieThumbnail(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result GetAutoSavingStorage(nn::sf::Out<nn::capsrv::AlbumStorageType> outValue) NN_NOEXCEPT;
        nn::Result GetRequiredStorageSpaceSizeToCopyAll(nn::sf::Out<std::uint64_t> outSize, nn::capsrv::AlbumStorageType dstStorage, nn::capsrv::AlbumStorageType srcStorage) NN_NOEXCEPT;

        // 静止画特化
        nn::Result LoadAlbumScreenShotImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImageEx0(nn::sf::Out<std::uint64_t> outWidth, nn::sf::Out<std::uint64_t> outHeight, nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result LoadAlbumScreenShotThumbnailImageEx1(nn::sf::Out<nn::capsrv::sf::LoadAlbumScreenShotImageOutputEx1> output, const nn::sf::OutBuffer& outBuffer, const nn::capsrv::AlbumFileId& fileId, const nn::capsrv::ScreenShotDecodeOption& option, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;

        // デバッグ用（DevMenuCommandSystem 用）
        nn::Result LoadMakerNoteInfoForDebug(nn::sf::Out<std::uint64_t> pOutFileSize, nn::sf::OutBuffer outInfoBuffer, const nn::capsrv::AlbumFileId& fileId, nn::sf::OutBuffer workBuffer) NN_NOEXCEPT;

        // テスト
        nn::Result ForceAlbumUnmounted(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result ResetAlbumMountStatus(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result RefreshAlbumCache(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumCache(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result GetAlbumCacheEx(nn::sf::Out<nn::capsrv::AlbumCacheData> outValue, nn::capsrv::AlbumStorageType storage, nn::capsrv::AlbumFileContentsType contents) NN_NOEXCEPT;
        nn::Result GetAlbumEntryFromApplicationAlbumEntryAruid(nn::sf::Out<nn::capsrv::AlbumEntry> outEntry, const nn::capsrv::ApplicationAlbumEntry& srcEntry, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result SetInternalErrorConversionEnabled(bool value) NN_NOEXCEPT;

        // セッション作成
        nn::Result OpenAccessorSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    };

}}}
