﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>
#include "../capsrvServer_Config.h"
#include "../capsrvServer_SessionId.h"
#include "../album/capsrvServer_MovieStreamIdTable.h"

namespace nn{ namespace capsrv{ namespace server{

    class AlbumControlSessionImpl
    {
    public:
        explicit AlbumControlSessionImpl() NN_NOEXCEPT;
        ~AlbumControlSessionImpl() NN_NOEXCEPT;

    private:
        SessionId m_SessionId;

    // @name IMovieReadStreamServiceObject
    // @{
    public:
        nn::Result OpenAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieReadStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result CloseAlbumMovieReadStream(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamMovieDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadMovieDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamImageDataSize(nn::sf::Out<std::int64_t> outSize, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadImageDataFromAlbumMovieReadStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result ReadFileAttributeFromAlbumMovieReadStream(nn::sf::Out<nn::capsrv::detail::ScreenShotAttributeEx0> outAttribute, nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieReadStreamBrokenReason(nn::capsrv::detail::AlbumMovieReadStreamHandleType handle) NN_NOEXCEPT;

    private:
        nn::Result CloseAllAlbumMovieReadStreams() NN_NOEXCEPT;

    private:
        album::MovieStreamIdTable<MovieReadStreamCountMax> m_MovieReadStreamIdTable;
    // @}


    // @name IMovieWriteStreamServiceObject
    // @{
    public:
        nn::Result OpenAlbumMovieWriteStream(nn::sf::Out<nn::capsrv::detail::AlbumMovieWriteStreamHandleType> outHandle, const nn::capsrv::AlbumFileId& fileId) NN_NOEXCEPT;
        nn::Result FinishAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result CommitAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result DiscardAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result DiscardAlbumMovieWriteStreamNoDelete(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result StartAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result EndAlbumMovieWriteStreamDataSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result StartAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result EndAlbumMovieWriteStreamMetaSection(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result ReadDataFromAlbumMovieWriteStream(nn::sf::Out<std::int64_t> outReadSize, const nn::sf::OutBuffer& outBuffer, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset) NN_NOEXCEPT;
        nn::Result WriteDataToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t offset, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
        nn::Result WriteMetaToAlbumMovieWriteStream(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, const nn::sf::InBuffer& inBuffer, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffet, std::int64_t makerNoteSize) NN_NOEXCEPT;
        nn::Result GetAlbumMovieWriteStreamBrokenReason(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result GetAlbumMovieWriteStreamDataSize(nn::sf::Out<std::int64_t> outValue, nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle) NN_NOEXCEPT;
        nn::Result SetAlbumMovieWriteStreamDataSize(nn::capsrv::detail::AlbumMovieWriteStreamHandleType handle, std::int64_t value) NN_NOEXCEPT;

    private:
        nn::Result DiscardAllAlbumMovieWriteStreams() NN_NOEXCEPT;

    private:
        album::MovieStreamIdTable<MovieWriteStreamCountMax> m_MovieWriteStreamIdTable;
    // @}
    };

}}}
