﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>
#include "capsrvServer_AlbumAccessorSessionImpl.h"
#include "capsrvServer_AlbumAccessorApplicationSessionImpl.h"

namespace nn{ namespace capsrv{ namespace server{

    class AlbumAccessorSessionFactory
    {
    public:
        static nn::Result Create(nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorSession>* pOutValue) NN_NOEXCEPT;
        static nn::Result Create(nn::sf::SharedPointer<nn::capsrv::sf::IAlbumAccessorApplicationSession>* pOutValue) NN_NOEXCEPT;
    };

}}}

