﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_TransferMemory.h>

namespace nn { namespace grc {

class UserManagerImpl
{
    NN_DISALLOW_COPY(UserManagerImpl);
    NN_DISALLOW_MOVE(UserManagerImpl);

public:
    UserManagerImpl() NN_NOEXCEPT {}

    /**
     * @brief
     */
    nn::Result Initialize(::nn::sf::NativeHandle&& transferMemoryHandle, uint64_t size ) NN_NOEXCEPT;

    /**
     * @brief
     */
    nn::Result Finalize() NN_NOEXCEPT;

private:
    void* pWorkmemory;
    ::nn::os::TransferMemoryType transferMemory;
};

}} // namespace nn::grc
