﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/grc/grc_Config.h>
#include "grc_UserManagerImpl.h"

namespace nn { namespace grc {

nn::Result UserManagerImpl::Initialize(
    ::nn::sf::NativeHandle&& transferMemoryHandle,
    uint64_t size) NN_NOEXCEPT
{
    pWorkmemory = nullptr;

    // Getting Transfer Memory's information
    auto transferMemoryOsHandle = transferMemoryHandle.GetOsHandle();
    auto isManaged = transferMemoryHandle.IsManaged();

    ::nn::os::AttachTransferMemory(
          &transferMemory, static_cast<size_t>(size), transferMemoryOsHandle, isManaged);

    ::nn::os::MapTransferMemory(
        &pWorkmemory,
        &transferMemory,
        ::nn::os::MemoryPermission_None);

#if 0
    // Please use following "address" as workspace
    uint64_t address = reinterpret_cast<uint64_t>(pWorkmemory);
    NN_GRC_LOG_INFO("You can use address : 0x%x size 0x%p as working buffer\n", size, pWorkmemory);
#endif

    NN_RESULT_SUCCESS;
}

nn::Result UserManagerImpl::Finalize() NN_NOEXCEPT
{
    ::nn::os::UnmapTransferMemory(&transferMemory);
    ::nn::os::DestroyTransferMemory(&transferMemory);

    NN_RESULT_SUCCESS;
}

}} // namespace nn::gamecast
