﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrv_CaptureConfig.h"
#include "capsrv_CaptureModule.h"

#include "../../Eris/Sources/Libraries/visrv/native/visrv_NativeType.h"

namespace nn{ namespace capsrv{ namespace capture{

    class MemoryPoolData;

    struct MemoryPoolImportData
    {
        NvRmMemHandle hMem;
        void* memory;
        size_t size;
    };

    class MemoryPool
    {
    public:
        typedef MemoryPoolData DataType;
        typedef MemoryPoolDataStorageType DataStorageType;
    public:
        static size_t GetRequiredAlignment() NN_NOEXCEPT;
        static size_t GetRequiredUnitSize() NN_NOEXCEPT;

        MemoryPool() NN_NOEXCEPT;

        nn::Result Initialize(CaptureModule* pModule, void* pMemory, size_t size) NN_NOEXCEPT;
        nn::Result InitializeAsImported(const MemoryPoolImportData& src) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT { return m_pData != nullptr; }
        DataType* GetData() NN_NOEXCEPT { return m_pData; }
        const DataType* GetData() const NN_NOEXCEPT { return m_pData; }

    private:
        DataType* m_pData;
        DataStorageType m_DataStorage;
    };

}}}
