﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "capsrv_CaptureConfig.h"
#include "capsrv_ImageFormat.h"
#include "capsrv_CaptureModule.h"
#include "capsrv_MemoryPool.h"
#include "capsrv_Rectangle.h"

namespace nn{ namespace capsrv{ namespace capture{
    class ImageBufferData;

    struct ImageBufferInfo
    {
        uint32_t    width;
        uint32_t    height;
        ImageFormat format;
    };

    class ImageBuffer
    {
    public:
        typedef ImageBufferData DataType;
        typedef ImageBufferDataStorageType DataStorageType;
        typedef ImageBufferInfo InfoType;
    public:
        ImageBuffer() NN_NOEXCEPT;

        static size_t GetRequiredMemorySize(const InfoType& info) NN_NOEXCEPT;
        static size_t GetRequiredMemoryAlignment(CaptureModule* pModule, const InfoType& info) NN_NOEXCEPT;

        nn::Result Initialize(CaptureModule* pModule, const InfoType& info, MemoryPool* pMemoryPool, ptrdiff_t offset, size_t size) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void FlushCache() const NN_NOEXCEPT;

        ImageFormat GetImageFormat() const NN_NOEXCEPT;

        nn::Result WriteToMemory(
            size_t* pOutSize,
            void* pBuffer,
            size_t bufferSize,
            ImageFormat dstFormat,
            const Rectangle* pSrcRectangle
        ) const NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT { return m_pData != nullptr; }
        DataType* GetData() NN_NOEXCEPT { return m_pData; }
        const DataType* GetData() const NN_NOEXCEPT { return m_pData; }

    private:
        DataType* m_pData;
        DataStorageType m_DataStorage;
    };

}}}
