﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_DisplayCapture.h"
#include "capsrv_DisplayCapture-module.stub.h"

#include <new>
#include <nn/nn_SdkAssert.h>

namespace nn{ namespace capsrv{ namespace capture{

    //------------------------------------
    // Interface
    //------------------------------------

    DisplayCapture::DisplayCapture() NN_NOEXCEPT
    {
        NN_CAPSRV_CAPTURE_DATASTORAGE_CHECK(DataType, m_DataStorage);
        std::memset(this, 0, sizeof(*this));
    }

    void DisplayCapture::Initialize(
        CaptureModule* pModule,
        const char* name,
        nn::vi::LayerStack layerStack,
        int width,
        int height,
        ImageFormat format
        ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!IsInitialized());
        m_pData = new(&m_DataStorage) DataType();
        return m_pData->Initialize(pModule, name, layerStack, width, height, format);
    }

    void DisplayCapture::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->Finalize();
        m_pData->~DataType();
        m_pData = nullptr;
    }

    void DisplayCapture::SetCaptureBuffer(int index, DisplayBuffer* pBuffer) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->SetCaptureBuffer(index, pBuffer);
    }

    void DisplayCapture::UnsetCaptureBuffer(int index) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->UnsetCaptureBuffer(index);
    }

    DisplayBuffer* DisplayCapture::AcquireCaptureBuffer(nn::TimeSpan timeout) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->AcquireCaptureBuffer(timeout);
    }

    DisplayBuffer* DisplayCapture::AcquireCaptureBuffer(nn::TimeSpan timeout, vi::LayerStack layerStack) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->AcquireCaptureBuffer(timeout, layerStack);
    }

    void DisplayCapture::ReleaseCaptureBuffer(DisplayBuffer* pBuffer) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        m_pData->ReleaseCaptureBuffer(pBuffer);
    }

    bool DisplayCapture::IsRecoveryRequired() const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->IsRecoveryRequired();
    }

    bool DisplayCapture::RecoverCapture(nn::TimeSpan timeout) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsInitialized());
        return m_pData->RecoverCapture(timeout);
    }

}}}

