﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "capsrv_DisplayBuffer.h"

#include <nn/nn_Result.h>
#include <nvrm_surface.h>
#include <system/window.h>
#include <gui/IGraphicBufferAlloc.h>
#include <ui/Fence.h>
#include "capsrv_ImageFormat.h"

namespace nn{ namespace capsrv{ namespace capture{

    class DisplayBufferData
    {
    public:
        static const int PlaneCountMax = 3;

    public:
        DisplayBufferData() NN_NOEXCEPT;

        // RGBA 用
        void InitializeRgba(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBuffer) NN_NOEXCEPT;
        // YUV(Planar) 用
        void InitializeYuvPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferU, ImageBuffer* pBufferV) NN_NOEXCEPT;
        // YUV(SemiPlanar) 用
        void InitializeYuvSemiPlanar(CaptureModule* pModule, ImageFormat format, ImageBuffer* pBufferY, ImageBuffer* pBufferUv) NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        void FlushCache() const NN_NOEXCEPT;

        bool IsContentTrivial() const NN_NOEXCEPT;

        nn::Result CopyToImageBuffer(
            ImageBuffer* pDstBuffer,
            CaptureModule* pModule,
            const Rectangle* pDstRect,
            FilterMode filterMode
        ) const NN_NOEXCEPT;

        android::sp<android::GraphicBuffer>& GetGraphicBuffer() NN_NOEXCEPT
        {
            return m_pGraphicBuffer;
        };

    public:
        CaptureModule* m_pModule;
        int          m_PlaneCount;
        ImageBuffer* m_pImageBufferList[PlaneCountMax];
        NvRmSurface  m_SurfaceList[PlaneCountMax];
        int          m_Width;
        int          m_Height;
        ImageFormat  m_Format;

        buffer_handle_t         m_hBuffer;
        android::sp<android::GraphicBuffer> m_pGraphicBuffer;

        bool     m_IsContentTrivial;
    };

}}}
