﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_DecoderControlApi.h"

#include <nn/capsrv/capsrv_Result.h>
#include "capsrv_DecoderControlServiceHolder.h"
#include "capsrv_Macro.h"

namespace nn{ namespace capsrv{

    nn::Result InitializeDecoderControl() NN_NOEXCEPT
    {
        NN_RESULT_DO(g_DecoderControlServiceHolder.Initialize(nullptr));
        NN_RESULT_SUCCESS;
    }

    void FinalizeDecoderControl() NN_NOEXCEPT
    {
        g_DecoderControlServiceHolder.Finalize();
    }

    nn::Result DecodeJpeg(
        void* pOutImageBuffer,
        size_t outImageBufferSize,
        const void* pInJpegBuffer,
        size_t inJpegBufferSize,
        int width,
        int height,
        const ScreenShotDecodeOption& option
    ) NN_NOEXCEPT
    {
        NN_CAPSRV_GET_SERVICE_POINTER(pService, g_DecoderControlServiceHolder);
        NN_RESULT_DO(pService->DecodeJpeg(
            nn::sf::OutBuffer(reinterpret_cast<char*>(pOutImageBuffer), outImageBufferSize),
            nn::sf::InBuffer(reinterpret_cast<const char*>(pInJpegBuffer), inJpegBufferSize),
            static_cast<uint32_t>(width),
            static_cast<uint32_t>(height),
            option
        ));
        NN_RESULT_SUCCESS;
    }

}}
