﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/svc/svc_Result.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/album/album_Result.h>
#include <nn/capsrv/capsrv_Result.h>

#include "album_ConvertCapsrvResult.h"
#include "album_Log.h"

namespace nn { namespace album {

// nn::capsrv::Result を nn::album::Result へ変換
Result ConvertCapsrvResult(Result result) NN_NOEXCEPT
{
    NN_ALBUM_LOG_DETAIL("[capsrv] Result: 0x%08x\n", result.GetInnerValueForDebug());

    NN_RESULT_TRY(result)
        NN_RESULT_CATCH(svc::ResultInvalidCurrentMemory)
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        }
        NN_RESULT_CATCH_CONVERT(fs::ResultNotMounted, album::ResultSdcardNotAvailable());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumIsNotMounted, album::ResultSdcardNotAvailable());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumIsFull, album::ResultAlbumFull());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumFileCountLimit, album::ResultAlbumFileCountLimit());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumFileSizeLimit, album::ResultAlbumFileSizeLimit());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumFileNotFound, album::ResultAlbumFileNotFound());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumInvalidFileId, album::ResultAlbumFileNotFound());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumReadBufferShortage, album::ResultAlbumFileDataError());
        NN_RESULT_CATCH_CONVERT(capsrv::ResultAlbumFileNoThumbnail, album::ResultAlbumFileDataError());
        NN_RESULT_CATCH_ALL
        {
            NN_RESULT_THROW(album::ResultAlbumError());
        }
    NN_RESULT_END_TRY;
    NN_RESULT_SUCCESS;
}

}}  // namespace nn::album
