﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/env.h>
#include <windows.h>

int ENVGetEnvironmentVariable(const char* key, char* value_buf, u32 value_buf_size)
{
    if (value_buf == NULL || value_buf_size == 0)
    {
        return -29; // IOS_ERROR_VALUE_INVALID_ARG
    }

    DWORD res = GetEnvironmentVariableA(key, value_buf, value_buf_size);
    if (res == 0 || res > value_buf_size)
    {
        value_buf[0] = '\0';
    }

    return 0; //IOS_ERROR_OK
}
