﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/os/OSInterrupt.h>
#include <winext/cafe/os/OSMutex.h>
#include <winext/cafe/os/OSCore.h>

namespace nw {
namespace internal {
namespace winext {

// 注意
//  割り込み禁止区間をクリティカルセクションと見なして
//  実装している
static OSMutex sCritSec;
static int sCounter = 0;
static bool sInitialized = false;

static void Init()
{
    OSGetCoreId();
    OSInitMutex(&sCritSec);
    sInitialized = true;
}

/*---------------------------------------------------------------------------*
  Name:         OSDisableInterrupts

  Description:  Disables external interrupt and decrementer exceptions

  Arguments:    None.

  Returns:      1 if interrupts were enabled, otherwise 0
 *---------------------------------------------------------------------------*/
BOOL OSDisableInterrupts(void)
{
    if ( ! sInitialized ) Init();

    OSLockMutex(&sCritSec);

    int counter = sCounter;
    sCounter++;

    return counter;
}

/*---------------------------------------------------------------------------*
  Name:         OSEnableInterrupts

  Description:  Enables external interrupt and decrementer exceptions

  Arguments:    None.

  Returns:      1 if interrupts were enabled, otherwise 0
 *---------------------------------------------------------------------------*/
BOOL OSEnableInterrupts(void)
{
    if ( ! sInitialized ) Init();

    OSLockMutex(&sCritSec);

    int counter = sCounter;

    while( sCounter > 0 ) {
        OSUnlockMutex(&sCritSec);
        sCounter--;
    }

    OSUnlockMutex(&sCritSec);

    return counter;
}

/*---------------------------------------------------------------------------*
  Name:         OSRestoreInterrupts

  Description:  Restores the previous interrupt level

  Arguments:    level       previous interrupt level

  Returns:      1 if interrupts were enabled, otherwise 0
 *---------------------------------------------------------------------------*/
BOOL OSRestoreInterrupts( BOOL level)
{
    OSLockMutex(&sCritSec);

    while( level > sCounter ) {
        sCounter++;
        OSLockMutex(&sCritSec);
    }

    while( level < sCounter ) {
        sCounter--;
        OSUnlockMutex(&sCritSec);
    }

    OSUnlockMutex(&sCritSec);

    return level;
}

void OSEnterInterrupts( void )
{
    if ( ! sInitialized ) Init();

    OSLockMutex(&sCritSec);
}

void OSLeaveInterrupts(void)
{
    OSUnlockMutex(&sCritSec);
}


} // namespace winext
} // namespace internal
} // namespace nw
