﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_AX_PRIVATE_H_
#define NW_WINEXT_AX_PRIVATE_H_

#include <winext/cafe/os.h>
#include <winext/cafe/ai.h>
#include <winext/cafe/ax.h>


namespace nw {
namespace internal {
namespace winext {

#define dpopMov       dpopDRC
#define mixMov        mixDRC


#define AX_CL_PROC_FINAL_MOV           AX_CL_PROC_FINAL_DRC
#define AX_CL_PROC_FINAL_DRC           0x000F
#define AX_CL_PROC_AUX_MOV             AX_CL_PROC_AUX_DRC


/*--------------------------------------------------------------------------*
    buffer addressing
 *--------------------------------------------------------------------------*/
typedef struct _AXPBADDR
{                                       // all values are mesured in samples:

    u16     loopFlag;                   // 0 = one-shot, 1=looping
    u16     format;                     // sample format used (see below)
    u16     segoff;                     // private ax usage
    u32     loopAddressHi;              // Start of loop (this will point to a shared "zero" buffer if one-shot mode is active)
    u32     loopAddressLo;
    u32     endAddressHi;               // End of sample (and loop)
    u32     endAddressLo;
    u32     currentAddressHi;           // Current playback position
    u32     currentAddressLo;

} AXPBADDR;

#define AXPBADDR_LOOPFLAG_OFF         AXPBADDR_OFF
#define AXPBADDR_FORMAT_OFF           (AXPBADDR_OFF+1)
#define AXPBADDR_LOOPADDRESSHI_OFF    (AXPBADDR_OFF+2)
#define AXPBADDR_LOOPADDRESSLO_OFF    (AXPBADDR_OFF+3)
#define AXPBADDR_ENDADDRESSHI_OFF     (AXPBADDR_OFF+4)
#define AXPBADDR_ENDADDRESSLO_OFF     (AXPBADDR_OFF+5)
#define AXPBADDR_CURRENTADDRESSHI_OFF (AXPBADDR_OFF+6)
#define AXPBADDR_CURRENTADDRESSLO_OFF (AXPBADDR_OFF+7)
#define AXPBADDR_SIZE                 8

/**************************************************************
 Private Stuff - as seen by renderers
 *************************************************************/
// OLD private mix ctrl fields (Left, Right, Ramp)
#define AX_PB_ST_MIX_CTRL_L   0x0001
#define AX_PB_ST_MIX_CTRL_R   0x0002
#define AX_PB_ST_MIX_CTRL_D   0x0004
#define AX_PB_ST_MIX_CTRL_AL  0x0010
#define AX_PB_ST_MIX_CTRL_AR  0x0020
#define AX_PB_ST_MIX_CTRL_AD  0x0040
#define AX_PB_ST_MIX_CTRL_BL  0x0100
#define AX_PB_ST_MIX_CTRL_BR  0x0200
#define AX_PB_ST_MIX_CTRL_BD  0x0400
#define AX_PB_ST_MIX_CTRL_CL  0x1000
#define AX_PB_ST_MIX_CTRL_CR  0x2000
#define AX_PB_ST_MIX_CTRL_CD  0x4000

// NEW private AXPBCHMIX mix ctrl fields (Left, Right)
#define AX_PB_MIX_CTRL_LMV    0x0001
#define AX_PB_MIX_CTRL_LMVD   0x0002
#define AX_PB_MIX_CTRL_RMV    0x0004
#define AX_PB_MIX_CTRL_RMVD   0x0008
#define AX_PB_MIX_CTRL_SLMV   0x0010
#define AX_PB_MIX_CTRL_SLMVD  0x0020
#define AX_PB_MIX_CTRL_SRMV   0x0040
#define AX_PB_MIX_CTRL_SRMVD  0x0080
#define AX_PB_MIX_CTRL_FCMV   0x0100
#define AX_PB_MIX_CTRL_FCMVD  0x0200
#define AX_PB_MIX_CTRL_LFEMV  0x0400
#define AX_PB_MIX_CTRL_LFEMVD 0x0800

// studio structure definition
#pragma pack(2)
typedef struct _AXSPB_STUDIO_CH
{
    s32 dpopVal;
    s16 dpopDelta;

} AXSPB_STUDIO_CH;
// #pragma pack()
// define studio buses for each of the devices here
typedef struct _AXSPB
{
    AXSPB_STUDIO_CH tvStudio[AX_MAX_NUM_TVS][AX_MAX_NUM_BUSES][AX_MAX_NUM_TV_CHS];
    AXSPB_STUDIO_CH drcStudio[AX_MAX_NUM_DRCS][AX_MAX_NUM_BUSES][AX_MAX_NUM_DRC_CHS];
    AXSPB_STUDIO_CH rmtStudio[AX_MAX_NUM_RMTS][AX_MAX_NUM_BUSES][AX_MAX_NUM_RMT_CHS];
} AXSPB;

// Private Renderer Voice Struct
// likely to get re-ordered when optimized for DMA timing later
// in fact now (20120326)
// moved state down and mix ctrls up to separate what only goes to DSP
// from what DSP may return to PPC.
typedef struct _AXPB
{
    u16             nextHi;     // hi word of mainmem addr of next param block
    u16             nextLo;     // lo word of mainmem addr of next param block

    u16             currHi;     // hi word of mainmem addr of curr param block
    u16             currLo;     // lo word of mainmem addr of curr param block

    u16             srcSelect;  // Select type of SRC (none,4-tap,linear)
    u16             coefSelect; // Coef. to be used with 4-tap SRC

    u16             mixerSelect; // 0 (AX_PB_MIXER_SELECT_DSP) or 1 (..._PPC)
    u16             type;       // type of voice (stream, normal, for ADPCM use)

    u16             tvMixCtrl[AX_MAX_NUM_TVS][AX_MAX_NUM_BUSES];
    u16             drcMixCtrl[AX_MAX_NUM_DRCS][AX_MAX_NUM_BUSES];

    AXPBCHMIX       tvMix[AX_MAX_NUM_TVS][AX_MAX_NUM_TV_CHS];  //
    AXPBCHMIX       drcMix[AX_MAX_NUM_DRCS][AX_MAX_NUM_DRC_CHS];
    AXPBCHMIX       rmtMix[AX_MAX_NUM_RMTS][AX_MAX_NUM_RMT_CHS];

    u16             remote;
    u16             rmtMixCtrl[AX_MAX_NUM_RMTS][AX_MAX_NUM_BUSES]; // Mixer control bits

    u16             state;      // RUN = 1, STOP = 0

    AXPBITD         itd;
    AXPBVE          ve;
    AXPBADDR        addr;
    AXPBADPCM       adpcm;
    AXPBSRC         src;
    AXPBADPCMLOOP   adpcmLoop;
    AXPBLPF         lpf;
    AXPBBIQUAD      biquad;

    s16             tvDpop[AX_MAX_NUM_TVS][AX_MAX_NUM_BUSES][AX_MAX_NUM_TV_CHS];  //
    s16             drcDpop[AX_MAX_NUM_DRCS][AX_MAX_NUM_BUSES][AX_MAX_NUM_DRC_CHS];  //
    s16             rmtDpop[AX_MAX_NUM_RMTS][AX_MAX_NUM_BUSES][AX_MAX_NUM_RMT_CHS];  //

    AXPBRMTSRC      rmtSrc;
    AXPBRMTIIR      rmtIIR;

    u16             PB_PAD[5];    // pad out to 32x size multiple for DSP DMA

    // PPC Only
    // extra stuff DSP does not need but saves PPC from needing
    // OSPhysicalToEffective() and Cache management calls
    u16             index;       // to get back to the parent AXVPB
    u16             mixerSelected; // i.e. which chain is I in?
    AXVPB           *p;           // to get back to the parent AXVPB
    struct _AXPB    *next;       // EA in priority chaining
    struct _AXPB    *PPC_next;   // EA in PPC Renderer chaining
    u32             sync;        // copy from AXVPB to pipline change flags

#ifndef AXMIX_EFFECTIVE
    u16             IO_pad[6];    // extra ? for multiple of 64 byte cache lines
#else
    u32             P_samples;  // cache p->offsets.samples physical address for PPC renderer
    const void     *E_samples;  // cache EA too, but this for the actual base this frame
    u16             IO_pad[2];  // extra ? for multiple of 64 byte cache lines
#endif
}AXPB;
#pragma pack()

#define AXPB_CACHE_ALIGN_PAD 11     // pad 0
/*--------------------------------------------------------------------------*
    old voice parameter block
 *--------------------------------------------------------------------------*/
typedef struct _AXPB_OLD
{

    u16             nextHi;     // pointer to next parameter buffer (MRAM)
    u16             nextLo;

    u16             currHi;     // pointer to this parameter buffer (MRAM)
    u16             currLo;

    u16             srcSelect;  // Select type of SRC (none,4-tap,linear)
    u16             coefSelect; // Coef. to be used with 4-tap SRC
    u32             mixerCtrl;  // Mixer control bits

    u16             state;      // current state (see below)
    u16             type;       // type of voice (stream)

    AXPBMIX         mix;
    AXPBITD         itd;
    AXPBDPOP        dpop;
    AXPBVE          ve;
    AXPBADDR        addr;
    AXPBADPCM       adpcm;
    AXPBSRC         src;
    AXPBADPCMLOOP   adpcmLoop;
    AXPBLPF         lpf;
    AXPBBIQUAD      biquad;

    u16             remote;

    u16             rmtMixerCtrl; // Mixer control bits

    AXPBRMTMIX      rmtMix;
    AXPBRMTDPOP     rmtDpop;
    AXPBRMTSRC      rmtSrc;
    AXPBRMTIIR      rmtIIR;

    u16             mixerSelect; // 0 (AX_PB_MIXER_SELECT_DSP) or 1 (..._PPC)

    AXPBDRCDPOP     DRCdpop; // 6 x u16
    AXPBDRCMIX      DRCmix;  // 12 x u16

    u16             index;  // to get back to the parent AXVPB

    u16             pad[7];     // also allow for AXVPB back link index
    u16            IO_pad[16];      // extra for multiple of 64 byte cache lines

} AXPB_OLD;


#define AX_PB_NEXTHI_OFF        0
#define AX_PB_NEXTLO_OFF        1
#define AX_PB_CURRHI_OFF        2
#define AX_PB_CURRLO_OFF        3
#define AX_PB_SRCSELECT_OFF     4
#define AX_PB_COEFSELECT_OFF    5
#define AX_PB_MIXERCTRL_OFF     6
#define AX_PB_STATE_OFF         8
#define AX_PB_TYPE_OFF          9
#define AXPBMIX_OFF             10

#define AXPBITD_OFF             (AXPBMIX_OFF       + AXPBMIX_SIZE)
#define AXPBDPOP_OFF            (AXPBITD_OFF       + AXPBITD_SIZE)
#define AXPBVE_OFF              (AXPBDPOP_OFF      + AXPBDPOP_SIZE)
#define AXPBADDR_OFF            (AXPBVE_OFF        + AXPBVE_SIZE)
#define AXPBADPCM_OFF           (AXPBADDR_OFF      + AXPBADDR_SIZE)
#define AXPBSRC_OFF             (AXPBADPCM_OFF     + AXPBADPCM_SIZE)
#define AXPBADPCMLOOP_OFF       (AXPBSRC_OFF       + AXPBSRC_SIZE)
#define AXPBLPF_OFF             (AXPBADPCMLOOP_OFF + AXPBADPCMLOOP_SIZE)
#define AXPBBIQUAD_OFF          (AXPBLPF_OFF       + AXPBLPF_SIZE)

#define AXPBREMOTE_OFF          (AXPBBIQUAD_OFF    + AXPBBIQUAD_SIZE)
#define AXPBRMTMIXCTRL_OFF      (AXPBREMOTE_OFF    + 1)
#define AXPBRMTMIX_OFF          (AXPBRMTMIXCTRL_OFF+ 1)
#define AXPBRMTDPOP_OFF         (AXPBRMTMIX_OFF    + AXPBRMTMIX_SIZE)
#define AXPBRMTSRC_OFF          (AXPBRMTDPOP_OFF   + AXPBRMTDPOP_SIZE)
#define AXPBRMTIIR_OFF          (AXPBRMTSRC_OFF    + AXPBRMTSRC_SIZE)

#define AX_PB_SIZE              (AXPBRMTIIR_OFF    +  AXPBRMTIIR_SIZE)

/*--------------------------------------------------------------------------*/
//#define AX_HOST_CL_WORDS                  64
#define AX_HOST_CL_WORDS                  96
//#define AX_HOST_CL_WORDS                  160
#define AX_HOST_CL_BYTES                 (AX_HOST_CL_WORDS * 2)

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#if (1) // use DDR times
/*--------------------------------------------------------------------------*/
// Cafe DDR3 bus access is slower than MEM1 in Wii
// MEM1 was 27 cycles, DDR3 is 100 cycles
// Adding a per 32 byte block fudge factor to account for this
//#define DSP_CYCLES_FUDGE_FACTOR 35 /* 73 */

// also adding in the cycles spent setting up Segment Offset registers
//#define SEGMENT_COST  2 /* 2 */

#define DSP_CYCLES_FUDGE_FACTOR __axcl_dsp_cycles_fudge_factor
#define SEGMENT_COST __axcl_segment_cost
// special exports from AXCL.c
extern u32 __axcl_dsp_cycles_fudge_factor;
extern u32 __axcl_segment_cost;

#define AX_CL_CYCLES_PARSING_TASK        2897
#define AX_CL_CYCLES_COMMON_DMA          4868
#define AX_CL_CYCLES_LOAD_COMMANDLIST   (  46 + ( 0*SEGMENT_COST) + (  2       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_INIT_STUDIO        (4126 + ( 2*SEGMENT_COST) + (  4       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_PROCESS_STEREO     ( 733 + ( 2*SEGMENT_COST) + ( 12       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_PROCESS_SURROUND   ( 829 + ( 2*SEGMENT_COST) + ( 12       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_PROCESS_DPL2       ( 925 + ( 2*SEGMENT_COST) + ( 24       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_PROCESS_AUX        (2235 + ( 4*SEGMENT_COST) + ( 36       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_PROCESS_AUX_DPL2   (3036 + (14*SEGMENT_COST) + ((36+12+48)*DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_COMPRESSOR         (1850 + ( 4*SEGMENT_COST) + (  6       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_OUTPUT_REMOTE      ( 409 + ( 4*SEGMENT_COST) + (  4       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_PROCESS_FINAL      (1172 + ( 4*SEGMENT_COST) + ( 24       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_PROCESS_FINAL_DPL2 (1195 + ( 6*SEGMENT_COST) + ( 36       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_CL_CYCLES_END                   30
/*--------------------------------------------------------------------------*/
#define AX_VOICE_CYCLES_BASE               32
#define AX_VOICE_CYCLES_BASE_VOICE      ( 600 + ( 4*SEGMENT_COST) + ( 12       *DSP_CYCLES_FUDGE_FACTOR))
#define AX_VOICE_CYCLES_BASE_ITD        ( 129 + ( 2*SEGMENT_COST) + (  2       *DSP_CYCLES_FUDGE_FACTOR))

#define AX_VOICE_CYCLES_VOICE_ON          387
#define AX_VOICE_CYCLES_LPF               309
#define AX_VOICE_CYCLES_BIQUAD           1024
#define AX_VOICE_CYCLES_ITD             (  27 + ( 2*SEGMENT_COST) + (  2       *DSP_CYCLES_FUDGE_FACTOR))

#define AX_VOICE_CYCLES_MIX_0               2 // NONE
#define AX_VOICE_CYCLES_MIX_1             408 // NORAMP_MONO
#define AX_VOICE_CYCLES_MIX_2             810 // NORAMP_STEREO
#define AX_VOICE_CYCLES_MIX_3            1404 // RAMP_STEREO
#define AX_VOICE_CYCLES_MIX_4             707 // RAMP_SURR
#define AX_VOICE_CYCLES_MIX_5            1115 // RAMP_SURR_NORAMP_MONO
#define AX_VOICE_CYCLES_MIX_6            1517 // RAMP_SURR_NORAMP_STEREO
#define AX_VOICE_CYCLES_MIX_7            2111 // RAMP_SURR_RAMP_STEREO

#define AX_VOICE_CYCLES_RMT_BASE          613
#define AX_VOICE_CYCLES_RMT_LPF           118
#define AX_VOICE_CYCLES_RMT_BIQUAD        834

#define AX_VOICE_CYCLES_RMT_MIX_0           4 // NONE
#define AX_VOICE_CYCLES_RMT_MIX_1          86 // NORAMP
#define AX_VOICE_CYCLES_RMT_MIX_2         151 // RAMP
/*--------------------------------------------------------------------------*/
#else
/*--------------------------------------------------------------------------*/
#define AX_CL_CYCLES_PARSING_TASK        2897
#define AX_CL_CYCLES_COMMON_DMA          4868
#define AX_CL_CYCLES_LOAD_COMMANDLIST      46
#define AX_CL_CYCLES_INIT_STUDIO         4126
#define AX_CL_CYCLES_PROCESS_STEREO       733
#define AX_CL_CYCLES_PROCESS_SURROUND     829
#define AX_CL_CYCLES_PROCESS_DPL2         925
#define AX_CL_CYCLES_PROCESS_AUX         2235
#define AX_CL_CYCLES_PROCESS_AUX_DPL2    3036
#define AX_CL_CYCLES_COMPRESSOR          1850
#define AX_CL_CYCLES_OUTPUT_REMOTE        409
#define AX_CL_CYCLES_PROCESS_FINAL       1172
#define AX_CL_CYCLES_PROCESS_FINAL_DPL2  1195
#define AX_CL_CYCLES_END                   30

/*--------------------------------------------------------------------------*/
#define AX_VOICE_CYCLES_BASE               32
#define AX_VOICE_CYCLES_BASE_VOICE        600
#define AX_VOICE_CYCLES_BASE_ITD          129

#define AX_VOICE_CYCLES_VOICE_ON          387
#define AX_VOICE_CYCLES_LPF               309
#define AX_VOICE_CYCLES_BIQUAD           1024
#define AX_VOICE_CYCLES_ITD                27

#define AX_VOICE_CYCLES_MIX_0               2 // NONE
#define AX_VOICE_CYCLES_MIX_1             408 // NORAMP_MONO
#define AX_VOICE_CYCLES_MIX_2             810 // NORAMP_STEREO
#define AX_VOICE_CYCLES_MIX_3            1404 // RAMP_STEREO
#define AX_VOICE_CYCLES_MIX_4             707 // RAMP_SURR
#define AX_VOICE_CYCLES_MIX_5            1115 // RAMP_SURR_NORAMP_MONO
#define AX_VOICE_CYCLES_MIX_6            1517 // RAMP_SURR_NORAMP_STEREO
#define AX_VOICE_CYCLES_MIX_7            2111 // RAMP_SURR_RAMP_STEREO

#define AX_VOICE_CYCLES_RMT_BASE          613
#define AX_VOICE_CYCLES_RMT_LPF           118
#define AX_VOICE_CYCLES_RMT_BIQUAD        834

#define AX_VOICE_CYCLES_RMT_MIX_0           4 // NONE
#define AX_VOICE_CYCLES_RMT_MIX_1          86 // NORAMP
#define AX_VOICE_CYCLES_RMT_MIX_2         151 // RAMP
/*--------------------------------------------------------------------------*/
#endif


// the comparison point is in s32q-8 format
#define COMPRESSOR_THRESHOLD      0x800000
#define COMPRESSOR_RELEASE_STAGES 10u

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
// Command indices - NB: ordinals to lookup tables in DSP and AXMix.c!!!
// retained commands
#define AX_CL_INIT_STUDIO              0x0000
#define AX_CL_PROCESS_GET_DEBUG_TRACE  (AX_CL_INIT_STUDIO + 1)              // 0x0001
#define AX_CL_PROCESS_DSP_VOICE        (AX_CL_PROCESS_GET_DEBUG_TRACE+1)    // 0x0002
#define AX_CL_PROCESS_PPC_VOICE        (AX_CL_PROCESS_DSP_VOICE+1)          // 0x0003
#define AX_CL_PROCESS_AUX              (AX_CL_PROCESS_PPC_VOICE + 1)        // 0x0004
#define AX_CL_FINALIZE                 (AX_CL_PROCESS_AUX + 1)              // 0x0005
#define AX_CL_OUTPUT_REMOTE            (AX_CL_FINALIZE + 1)                 // 0x0006
#define AX_CL_END                      (AX_CL_OUTPUT_REMOTE + 1)            // 0x0007
#define AX_CL_LAST_CMD                 AX_CL_END                            // 0x0007

/*-------  Define [bus_id]; used in the indirection of the buses for CL ------ */
typedef enum _BUSIDX
{

    AX_TV_MAIN_BUS_IDX = 0,
    AX_TV_AUXA_BUS_IDX,
    AX_TV_AUXB_BUS_IDX,
    AX_TV_AUXC_BUS_IDX,
    AX_DRC0_MAIN_BUS_IDX,
    AX_DRC0_AUXA_BUS_IDX,
    AX_DRC0_AUXB_BUS_IDX,
    AX_DRC0_AUXC_BUS_IDX,
    AX_DRC1_MAIN_BUS_IDX,
    AX_DRC1_AUXA_BUS_IDX,
    AX_DRC1_AUXB_BUS_IDX,
    AX_DRC1_AUXC_BUS_IDX
}AX_BUSIDX;

/*******************************************************************************/
// command list command lengths (in u16 increments)
#define AX_CL_INIT_STUDIO_LEN        3     /* 0x0000 0 [u16 opcode][U32 src_addr] */
#define AX_CL_PROCESS_GET_DBG_TRC_LEN   3     /* 0x0002 2 [u16 opcode][U32 src_addr] */
#define AX_CL_PROCESS_DSP_VOICE_LEN      3     /* 0x0004 4 [u16 opcode][U32 src_addr] */
#define AX_CL_PROCESS_PPC_VOICE_LEN      3     /* 0x0004 4 [u16 opcode][U32 src_addr] */
#define AX_CL_OUTPUT_REMOTE_LEN       9    /* 0x000D D [u16 opcode][U32 main0_addr][U32 main1_addr][U32 main2_addr][U32 main3_addr] */
// 2.0 commands
#define AX_CL_PROCESS_AUX_LEN         8    /* 0x0011   [u16 opcode][u16 bus_id][u16 numchans] */
                                           /*          [u16 target_vol][U32 src_addr][U32 dest_addr] */
#define AX_CL_FINALIZE_LEN            6    /* 0x0012   [u16 opcode][u16 bus_id][u16 numchans][u16 target_vol][U32 dest_addr] */
#define AX_CL_END_LEN                 1    /* 0x000E E [u16 opcode] */
/*--------------------------------------------------------------------------*/
#define AX_CYCLES_PER_SAMPLE             3797 //121.5MHz / 32KHz
#define AX_CYCLES_PER_USEC                122 //121.5MHz / 32KHz

/*--------------------------------------------------------------------------*/
#define AX_OUT_SAMPLES_PER_MS              32
#define AX_OUT_SAMPLES_PER_SEC            (AX_OUT_SAMPLES_PER_MS * 1000)
#define AX_OUT_SAMPLES_PER_FRAME          (AX_OUT_SAMPLES_PER_MS * AX_MS_PER_FRAME)

#ifdef _DEBUG
#define AX_OUT_CONSUMED_OFFSET            400 // 400usec
#else
#define AX_OUT_CONSUMED_OFFSET            200 // 200usec
#endif

/*--------------------------------------------------------------------------*/
#define AX_RMT_CHANNELS                     4
#define AX_RMT_MAX_BLOCKS                  10

typedef struct
{
    s16 *rmt0;
    s16 *rmt1;
    s16 *rmt2;
    s16 *rmt3;

} AXRmtBuffs;

/*--------------------------------------------------------------------------*/
#define AX_DSP_FRAME_NOT_COMPLETE           0
#define AX_DSP_FRAME_COMPLETE               1
#define AX_DSP_FRAME_MAKEFRAME              2

/*--------------------------------------------------------------------------*/
typedef struct AX_AUX_DATA
{
    s32        *l;
    s32        *r;
    s32        *s;

} AX_AUX_DATA;


typedef struct AX_AUX_DATA_DPL2
{
    s32        *l;
    s32        *r;
    s32        *ls;
    s32        *rs;

} AX_AUX_DATA_DPL2;

typedef struct AX_AUX_DATA_6CH
{
    s32        *l;
    s32        *r;
    s32        *ls;
    s32        *rs;
    s32        *fc;
    s32        *lfe;

} AX_AUX_DATA_6CH;

/*--------------------------------------------------------------------------*/
extern u32 __AXDeviceMode[AX_MAX_NUM_DEVICES];
extern AXPROFILE __AXLocalProfile;
extern u32 __AXMaxVoices;

extern u32 __AXMixingMode;
typedef void (*AXMixerCallback)(u16 *cmd, u32 bPost);
AXMixerCallback __AXRegisterMixerMode(AXMixerCallback mix_cb, u32 mix_mode);

/*--------------------------------------------------------------------------*/
void        __AXSPBInit                     (void);
void        __AXSPBQuit                     (void);
void        __AXDepopFadeMain               (s32 *hostSum, AXSPB_STUDIO_CH *studio, s32 duration);
void        __AXDepopVoice                  (AXPB *p);
u32         __AXGetStudio                   (void);
void        __AXPrintStudio                 (void);

void        __AXClInit                      (void);
void        __AXClQuit                      (void);
u32         __AXGetCommandListAddress       (AXPB * root_dsp, AXPB * root_ppc);
u32         __AXGetCommandListCycles        (void);
void        __AXGetCommandListCosts         (f32 *dsp_costs, f32 *ax_costs);
void        __AXWriteToCommandList          (u16 data);
void        __AXNextFrame                   (void *buffer,
                                             AXRmtBuffs *rbuffer,
                                             AXPB *root_dsp,
                                             AXPB *root_ppc,
                                             void *drcbuffer_0,
                                             void *drcbuffer_1);

void        __AXAllocInit                   (void);
void        __AXAllocQuit                   (void);
void        __AXInitVoiceStacks             (void);
void        __AXPushFreeStack               (AXVPB *p);
AXVPB*      __AXPopFreeStack                (void);
void        __AXPushCallbackStack           (AXVPB *p);
AXVPB*      __AXPopCallbackStack            (void);
void        __AXServiceCallbackStack        (void);
void        __AXPushStackHead               (AXVPB *p, u32 priority);
void        __AXRemoveFromStack             (AXVPB *p);
AXVPB*      __AXPopStackFromBottom          (u32 priority);
AXVPB*      __AXGetStackHead                (u32 priority);

void        __AXVPBInit                     (void);
void        __AXVPBInitSpecifyMem           (u32 num, void* mem);
void        __AXVPBQuit                     (void);
void        __AXServiceVPB                  (AXVPB *pvpb);
void        __AXDumpVPB                     (AXVPB *pvpb);
//void        __AXSyncPBs                     (f32 UserCosts, f32 DspCosts, AXPB **root_dsp, AXPB **root_ppc);

// 1 デバイスごとのチャンネル数
static const u32 MIX_BUFFER_COUNT_TV  = AX_MAX_NUM_TV_CHS  * AX_MAX_NUM_BUSES;  // 6 x 4 = 24ch
static const u32 MIX_BUFFER_COUNT_DRC = AX_MAX_NUM_DRC_CHS * AX_MAX_NUM_BUSES;  // 4 x 4 = 16ch
static const u32 MIX_BUFFER_COUNT_RMT = AX_MAX_NUM_RMT_CHS * AX_MAX_NUM_RMT_BUSES;  // 1 x 1 = 1ch

static const u32 MIX_BUFFER_COUNT =
        AX_MAX_NUM_TVS  * MIX_BUFFER_COUNT_TV       // 1 x 24 = 24ch
      + AX_MAX_NUM_DRCS * MIX_BUFFER_COUNT_DRC      // 2 x 16 = 32ch
      + AX_MAX_NUM_RMTS * MIX_BUFFER_COUNT_RMT;     // 4 x  1 =  4ch

struct BusBuffer
{
    signed int* buffers[MIX_BUFFER_COUNT];

    BusBuffer() {
        for (u32 i = 0; i < MIX_BUFFER_COUNT; i++)
        {
            buffers[i] = NULL;
        }
    }
};
int __AXSyncPBs(
                int channels,
                BusBuffer* busBuffer,
                unsigned long samples,
                int sampleRate
                );

s32* __AXGetAuxBus(AXPBDeviceType device, u32 deviceId, u32 auxId, u32 ch);
void __AXClearAuxBus(void);

AXPB*       __AXGetPBs                      (void);
AXVPB*      __AXGetVPBs                     (void);
void        __AXSetPBDefault                (AXVPB *p);
BOOL        __AXServicingFrame              (void);
void        __AXVoiceProtect                (AXVPB *p);
void        __AXVoiceUnprotect              (AXVPB *p);
BOOL        __AXVoiceIsProtected            (AXVPB* p);

void        __AXAuxInit                     (void);
void        __AXAuxQuit                     (void);
void        __AXGetAuxInput                 (u32 device, u32 id, u32 aux_id, u32 *p);
void        __AXGetAuxOutput                (u32 device, u32 id, u32 aux_id, u32 *p);
void        __AXProcessAux                  (void);
void        __AXClearTVAuxBuffers           (void);
void        __AXClearDRCAuxBuffers          (void);

void        __AXOutInit                     (u32 outputBufferMode);
void        __AXOutQuit                     (void);
void        __AXOutInitDSP                  (void);
u32         __AXOutNewFrame                 (void);
void        __AXOutAiCallback               (void);
void        __AXOutOnForeground             (void);
void        __AXOutOnBackground             (void);

void        __AXOnForeground                (void);
void        __AXOnBackground                (void);

AXPROFILE*  __AXGetCurrentProfile           (void);

// SdK 2.0.5 - leading underscores dropped and published to ax.h
//u32         __AXGetNumVoices                (void);
//u32         __AXGetNumDspVoices             (void);


void    __AXSetMode                   (u32 mode);
AXPB_ERROR_CODE __AXSetDeviceMode(AXPBDeviceType device, u32 mode);

/* Ramp transition regarding*/
typedef enum {
    AX_RAMP_DONE=0,
    AX_RAMP_UP,
    AX_RAMP_DOWN
}AX_RAMP_STATE_TYPE;
void __AXSetRampState(AX_RAMP_STATE_TYPE  rampState);
void __AXHandleRamp(void );
AX_RAMP_STATE_TYPE __AXGetRampState(void);


/* Compressor related functions*/
void __AXApplyCompressorOneDevice(s32 *input, u16 const *table, u32 const numSamples,
                                    const u32 numChannels, u32 *compState, const u32 compReleaseFrames);

void __AXApplyCompressorOneChannel(s32 *input, u16 const *table, u32 const numSamples);
void __AXCompInit(void);
void __AXApplyDeviceCompressor(s32 *input, AXPBDeviceType const deviceType, u32 const deviceId);



void __AXRegisterDrivers(void);
void __AXDeregisterDrivers(void);

/*================ remix structures ====================*/
typedef struct {

    u32 numInChns;                    // number of input channels
    u32 numOutChns;                    // number of output channels
    f32 const *matrix;                // pointer to array of [numOutChns][numInChns]
} AXDeviceRemixStruct;

#define     AX_MONO_CHANNELS        (1)
#define     AX_STEREO_CHANNELS      (2)
#define     AX_SURROUND_CHANNELS    (6)
#define     AX_6CHAN_CHANNELS       (6)

#define AX_DEFAULT_UPSAMPLER_IS_LINEAR  FALSE




/*--------------------------------------------------------------------------*/

} // namespace winext
} // namespace internal
} // namespace nw

#endif // NW_WINEXT_AX_PRIVATE_H_
