﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <winext/types.h>
#include "ai_dma.h"
#include <new>

#include <pthread.h>

// iOS headers
#include <pthread.h>
#include <semaphore.h>

namespace nw {
    namespace internal {
        namespace winext {

            class CSoundEngineCoreAudio
            {

            public:
                typedef void (*WaveOutCallbackFunc)(
                        int channels,
                        signed short* buffer,
                        unsigned long samples,
                        int sampleRate);

                static CSoundEngineCoreAudio* Instance()
                {
                    if (sInstance == NULL)
                    {
                        sInstance = new(sInstanceMemory) CSoundEngineCoreAudio;
                    }
                    return sInstance;
                }
                static void DestroyInstance()
                {
                    if ( sInstance != NULL )
                    {
                        sInstance->~CSoundEngineCoreAudio();
                        sInstance = NULL;
                    }
                }

                virtual bool IsActive() const;

                virtual bool OpenStream(unsigned int devideID);
                virtual void CloseStream();

                virtual unsigned long GetBufferLength()
                {
                    return WAVE_BUF_SIZE;
                }

                void RequestRender();
                WaveOutCallbackFunc GetWaveOutCallback()
                {
                    return m_WaveOutProc;
                }

                WaveOutCallbackFunc SetWaveOutCallback( WaveOutCallbackFunc func )
                {
                    if(m_WaveOutProc == func)
                    {
                        return NULL;
                    }

                    WaveOutCallbackFunc oldFunc = m_WaveOutProc;
                    m_WaveOutProc = func;

                    return oldFunc;
                }

                static const int BUFFER_COUNT = 2;

            private:
                static const int CHANNEL_COUNT = 2;
                sem_t *m_pRenderRequestSemaphore;
                static const int SAMPLE_RATE = 48000;
                static const int WAVE_BUF_SAMPLES = 144;
                static const int WAVE_BUF_SIZE = WAVE_BUF_SAMPLES * 2 * CHANNEL_COUNT;

                CSoundEngineCoreAudio();
                virtual ~CSoundEngineCoreAudio();
                pthread_t m_Thread;
                bool m_IsActive;
                volatile bool m_RequestExitThread;

                static void* threadProcFunc(void* args);
                void* ThreadProc(void* args);

                void RenderAudioFrames(s16 *dst, s32 numFrames);
                bool WaitForRequestRender();

                static CSoundEngineCoreAudio* sInstance;
                static u8 sInstanceMemory[];
                void WaveOutCallback(
                        int channels,
                        signed short* buffer,
                        unsigned long samples,
                        int sampleRate )
                {
                    if ( m_WaveOutProc )
                    {
                        m_WaveOutProc( channels, buffer, samples, sampleRate );
                    }
                }

            private:
                WaveOutCallbackFunc m_WaveOutProc;

            };

        } // namespace adrext
    } // namespace internal
} // namespace nw
