﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>
#include <nw/ut.h>
#include <nw/ut/ut_RuntimeTypeInfo.h>
#include <nw/ut/ut_IoStream.h>

namespace nw {
namespace ut {


//---------------------------------------------------------------------------
s32
IoStream::Read( void* buf, u32 length )
{
    NW_UNUSED_VARIABLE(buf)
    NW_UNUSED_VARIABLE(length)

    NW_TASSERTMSG( CanRead(), "Stream don't support READ function\n" );
    return 0;
}


//---------------------------------------------------------------------------
bool
IoStream::ReadAsync( void* buf, u32 length, IoStreamCallback callback, void* arg )
{
    NW_UNUSED_VARIABLE(buf)
    NW_UNUSED_VARIABLE(length)
    NW_UNUSED_VARIABLE(callback)
    NW_UNUSED_VARIABLE(arg)

    NW_TASSERTMSG( CanRead(), "Stream don't support READ function\n" );
    NW_TASSERTMSG( CanAsync(), "Stream don't support ASYNC function\n" );
    return false;
}


//---------------------------------------------------------------------------
s32
IoStream::Write( const void* buf, u32 length )
{
    NW_UNUSED_VARIABLE(buf)
    NW_UNUSED_VARIABLE(length)

    NW_TASSERTMSG( CanWrite(), "Stream don't support WRITE function\n" );
    return 0;
}


//---------------------------------------------------------------------------
bool
IoStream::WriteAsync( const void* buf, u32 length, IoStreamCallback callback, void* arg )
{
    NW_UNUSED_VARIABLE(buf)
    NW_UNUSED_VARIABLE(length)
    NW_UNUSED_VARIABLE(callback)
    NW_UNUSED_VARIABLE(arg)

    NW_TASSERTMSG( CanWrite(), "Stream don't support WRITE function\n" );
    NW_TASSERTMSG( CanAsync(), "Stream don't support ASYNC function\n" );
    return false;
}


//---------------------------------------------------------------------------
s32
IoStream::WaitAsync( void )
{
    NW_TASSERTMSG( CanAsync(), "Stream don't support ASYNC function\n" );

    while ( IsBusy() ) {}
    return m_AsyncResult;
}


//---------------------------------------------------------------------------
bool
IoStream::IsBusy( void ) const
{
    NW_TASSERTMSG( CanAsync(), "Stream don't support ASYNC function\n" );
    return false;
}


}   /* namespace ut */
}   /* namespace nw */

