﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>
#include <nw/ut/os/ut_Print.h>

// NW_ADAPTIVE_HEADER マクロが使用可能な場合の処理。
#include <nw/config/macros.h>

#if defined( NW_PLATFORM_WIN32 ) || defined( NW_PLATFORM_CAFE ) || defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
#include NW_ADAPTIVE_HEADER_LOCAL(./platform/ut_Print_, NW_PLATFORM_NAME.cpp)
#elif defined( NW_USE_NINTENDO_SDK )
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include NW_ADAPTIVE_HEADER_LOCAL(./platform/ut_Print_, win32.cpp)
#else
#error "Unsuppoted platform."
#endif


namespace nw {
namespace ut {

extern void Panic( const char* fileName, int line, const char* fmt, ...) NW_WEAK_ATTRIBUTE;
extern void TPanic( const char* fileName, int line, const char* fmt, ...) NW_WEAK_ATTRIBUTE;
extern void Warning( const char* fileName, int line, const char* fmt, ...) NW_WEAK_ATTRIBUTE;
extern void TWarning( const char* fileName, int line, const char* fmt, ...) NW_WEAK_ATTRIBUTE;
extern void Printf(const char *fmt, ...) NW_WEAK_ATTRIBUTE;
extern void TPrintf(const char *fmt, ...) NW_WEAK_ATTRIBUTE;


//---------------------------------------------------------------------------
void
Printf(const char *fmt, ...)
{
    std::va_list vlist;
    va_start(vlist, fmt);

    VPrintf(fmt, vlist);

    va_end(vlist);
}

//---------------------------------------------------------------------------
void
TPrintf(const char *fmt, ...)
{
    std::va_list vlist;
    va_start(vlist, fmt);

    TVPrintf(fmt, vlist);

    va_end(vlist);
}


//---------------------------------------------------------------------------
void
Warning( const char* fileName, int line, const char* fmt, ...)
{
    va_list vlist;
    va_start(vlist, fmt);

    Printf("%s:%d Warning:", fileName, line);
    VPrintf(fmt, vlist);
    Printf("\n");

    va_end(vlist);
}

//---------------------------------------------------------------------------
void
TWarning( const char* fileName, int line, const char* fmt, ...)
{
    va_list vlist;
    va_start(vlist, fmt);

    TPrintf("%s:%d Warning:", fileName, line);
    TVPrintf(fmt, vlist);
    TPrintf("\n");

    va_end(vlist);
}


//---------------------------------------------------------------------------
void
Panic( const char* fileName, int line, const char* fmt, ...)
{
    std::va_list vlist;
    va_start(vlist, fmt);

    Printf("%s:%d Panic:", fileName, line);
    VPrintf(fmt, vlist);
    Printf("\n");

    va_end(vlist);

    Halt();
}

//---------------------------------------------------------------------------
void
TPanic( const char* fileName, int line, const char* fmt, ...)
{
    std::va_list vlist;
    va_start(vlist, fmt);

    TPrintf("%s:%d Panic:", fileName, line);
    TVPrintf(fmt, vlist);
    TPrintf("\n");

    va_end(vlist);

    Halt();
}

//---------------------------------------------------------------------------
void
HaltWithDetail(const char* codePos, int lineNo, const char* format, ...)
{
    Printf("%s(%d): ", codePos, lineNo);

    {
        va_list list;
        va_start( list, format );

        VPrintf(format, list);

        va_end( list );
    }

    Printf("\n");

    Halt();
}



}  // namespace ut
}  // namespace nw


