﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/types.h>

#include <cstdio>
#include <cstdarg>
#include <cstring>

#include <cafe/os.h>

#include <nw/ut/ut_String.h>

namespace nw {
namespace ut {

//---------------------------------------------------------------------------
void
PutString(const char* str)
{
    OSConsoleWrite(str, std::strlen(str));
}

//---------------------------------------------------------------------------
void
VPrintf(const char *fmt, std::va_list vlist)
{
    static const size_t MAX_DEBUG_STRING_LENGTH = 260;
    static char sDebugString[MAX_DEBUG_STRING_LENGTH];

    nw::ut::vsnprintf(sDebugString, MAX_DEBUG_STRING_LENGTH, sizeof(sDebugString) - 1, fmt, vlist);

    PutString(sDebugString);
}

//---------------------------------------------------------------------------
void
TVPrintf(const char *fmt, std::va_list vlist)
{
    OSVReport(fmt, vlist);
}


//---------------------------------------------------------------------------
void
Halt()
{
    if (OSIsDebuggerPresent())
    {
#if defined (NW_COMPILER_GHS)
        OSDebug();
#endif
    }
    else
    {
        OSHalt("halt");
    }
}

}  // namespace ut
}  // namespace nw
