﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/math/math_Constant.h>

namespace nw { namespace math {


const f32 F_E       = 2.718281828459045f;   //!< ネピア数 (自然対数の底) e
const f32 F_LOG2E   = 1.442695040888963f;   //!< log2(e)
const f32 F_LOG10E  = 0.434294481903251f;   //!< log10(e)
const f32 F_LN2     = 0.693147180559945f;   //!< ln(2)
const f32 F_LN10    = 2.302585092994045f;   //!< ln(10)
const f32 F_PI      = 3.141592653589793f;   //!< π
const f32 F_SQRTPI  = 1.772453850905516f;   //!< sqrt(π)
const f32 F_SQRT2   = 1.414213562373095f;   //!< sqrt(2)
const f32 F_SQRT3   = 1.732050807568877f;   //!< sqrt(3)

const f32 F_INVLN2  = 1.442695040888963f;   //!< 1/ln2


const f32 F_MAX     = FLT_MAX;              //!< 最大の正の数 = 3.40282346638529 * 10^38
const f32 F_MIN     = FLT_MIN;              //!< 最小の正の数 = 1.17549435082229 * 10^-38

const u32 I_QUARTER_ROUND_IDX = 0x40000000; //!< インデックス角度での1/4周
const u32 I_HALF_ROUND_IDX    = 0x80000000; //!< インデックス角度での半周

namespace internal {
    const u32 I_NAN     = 0x7FFFFFFF;   // sign=+ exp=max frac=max
    const u32 I_INF     = 0x7F800000;   // sign=+ exp=max frac=0
    const u32 I_NINF    = 0xFF800000;   // sign=- exp=max frac=0
    const u32 I_ULP     = 0x34000000;   // sign=+ exp=-23 frac=0
}

const f32 F_NAN     = std::numeric_limits<f32>::quiet_NaN();    //!< 非数
const f32 F_INF     = std::numeric_limits<f32>::infinity();     //!< ∞
const f32 F_NINF    = -F_INF;                                   //!< -∞
const f32 F_ULP     = std::numeric_limits<f32>::epsilon() * 2;  //!< 1.0f + x != 1.0f を満たす最小の正の値

}}  // nw::math
