﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace internal {
namespace dw {

nw::math::Vector3 NwTypeUtility::ToVector3(const nw::math::Vector2& value)
{
    return nw::math::Vector3(value.x, value.y, 0.f);
}

nw::dev::PrimitiveRenderer::QuadArg NwTypeUtility::ToQuadArg(const DrawRectangleArgs& value)
{
    nw::dev::PrimitiveRenderer::QuadArg result;
    result.SetCornerAndSize(ToVector3(value.topLeft), value.size);

    switch(value.colorOrientation)
    {
    case HORIZONTAL:
        result.SetColorHorizontal(value.color0, value.color1);
        break;

    case VERTICAL:
        // NOTE : 下方向をY軸の正方向とするため、Color0 と Color1 を逆転させます。
        result.SetColor(value.color1, value.color0);
        break;

    default:
        NW_ASSERTMSG(false, "invalid Orientation.");
    }

    return result;
}

//----------------------------------------
f32 NwTypeUtility::SRGBToLinear(f32 src)
{
    if (src <= 0.04045f)
    {
        return src / 12.92f;
    }
    else
    {
        return std::pow(((src + 0.055f) / 1.055f), 2.4f);
    }
}

//----------------------------------------
f32 NwTypeUtility::LinearToSRGB(f32 src)
{
    if (src <= 0.0031308f)
    {
       return 12.92f * src;
    }
    else
    {
       return (1.055f * std::pow(src, 1.0f / 2.4f)) - 0.055f;
    }
}

} // dw
} // internal
} // nw
