﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_UIElementTreeContext.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_UIElementUtility.h>

namespace nw {
namespace internal {
namespace dw {

UIElementTreeContext::UIElementTreeContext() :
m_Level(0),
m_pCurrenElement(NULL),
m_UIElementOrigin(0.f, 0.f)
{
}

const UIElement* UIElementTreeContext::PushUIElement(const UIElement& element)
{
    const UIElement* result = m_pCurrenElement;

    m_pCurrenElement = &element;
    UIElementUtility::PositionToParentClient(&m_UIElementOrigin, element);

    ++m_Level;

#if 0
    NW_LOG("[%2d] [%20s] pos(%6.2f, %6.2f), size(%6.2f, %6.2f), marg(%6.2f, %6.2f, %6.2f, %6.2f), padd(%6.2f, %6.2f, %6.2f, %6.2f)\n",
        m_Level,
        element.ToString(),
        element.GetTopLeft().x,
        element.GetTopLeft().y,
        element.GetFixedSize().x,
        element.GetFixedSize().y,
        element.GetMargin().left,
        element.GetMargin().top,
        element.GetMargin().right,
        element.GetMargin().bottom,
        element.GetPadding().left,
        element.GetPadding().top,
        element.GetPadding().right,
        element.GetPadding().bottom);
#endif

    return result;
}

void UIElementTreeContext::PopUIElement(const UIElement* pPreviousElement)
{
    if(m_Level == 0)
    {
        return;
    }

    NW_ASSERT(m_pCurrenElement != NULL);

    --m_Level;

    if(m_Level == 0)
    {
        m_pCurrenElement = NULL;
        m_UIElementOrigin.x = 0.f;
        m_UIElementOrigin.y = 0.f;
    }
    else
    {
        NW_ASSERT(pPreviousElement != NULL);

        UIElementUtility::PositionToChildClient(&m_UIElementOrigin, *m_pCurrenElement);
        m_pCurrenElement = pPreviousElement;
    }
}

int UIElementTreeContext::GetLevel() const
{
    return m_Level;
}

const UIElement* UIElementTreeContext::GetCurrentElement() const
{
    return m_pCurrenElement;
}

void UIElementTreeContext::OffsetCurrentElementOrigin(const nw::math::Vector2& offset)
{
    m_UIElementOrigin += offset;
}

nw::math::Vector2 UIElementTreeContext::ScreenToClient(const nw::math::Vector2& position) const
{
    return nw::math::Vector2(position.x - m_UIElementOrigin.x, position.y - m_UIElementOrigin.y);
}

nw::math::Vector2 UIElementTreeContext::ClientToScreen(const nw::math::Vector2& position) const
{
    return nw::math::Vector2(position.x + m_UIElementOrigin.x, position.y + m_UIElementOrigin.y);
}

const nw::math::Vector2& UIElementTreeContext::GetRenderOffset() const
{
    return m_UIElementOrigin;
}

} // dw
} // internal
} // nw
